package com.ejianc.business.steelstructure.finance.service;

import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;

/**
 * 付款申请详情
 * 
 * @author generator
 * 
 */
public interface IPaymentApplyDetailService extends IBaseService<PaymentApplyDetailEntity> {

    /**
     * 查询当前结算单的 已申请金额
     * @param sourceId
     * @return
     */
    BigDecimal queryAlreadyApplyMny(String sourceId);

    /**
     * 设置剩余可申请金额
     * @param settlePoolVO
     * @return
     */
    SettlePoolVO setResidueMny(SettlePoolVO settlePoolVO);



    boolean releaseApplyList(PaymentApplyEntity entity);
}
