package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 费税清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_steel_budget_fee")
public class BudgetFeeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="fee_code")
    private String feeCode; // 编码
    @TableField(value="fee_name")
    private String feeName; // 名称
    @TableField(value="fee_feature")
    private String feeFeature; // 特征
    @TableField(value="fee_tax_rate")
    private BigDecimal feeTaxRate; // 税率
    @TableField(value="fee_mny")
    private BigDecimal feeMny; // 合价(无税)
    @TableField(value="fee_tax_mny")
    private BigDecimal feeTaxMny; // 合价(含税)
    @TableField(value="fee_tax")
    private BigDecimal feeTax; // 税额
    @TableField(value="fee_memo")
    private String feeMemo; // 备注
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="fee_subject_id")
    private Long feeSubjectId; // 成本科目id
    @TableField(value="fee_subject_name")
    private String feeSubjectName; // 成本科目名称

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    public Long getFeeSubjectId() {
        return feeSubjectId;
    }

    public void setFeeSubjectId(Long feeSubjectId) {
        this.feeSubjectId = feeSubjectId;
    }

    public String getFeeSubjectName() {
        return feeSubjectName;
    }

    public void setFeeSubjectName(String feeSubjectName) {
        this.feeSubjectName = feeSubjectName;
    }

    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getFeeCode() {
        return feeCode;
    }

    /**
     * 编码
     */
    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }
    /**
     * 名称
     */
    public String getFeeName() {
        return feeName;
    }

    /**
     * 名称
     */
    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    /**
     * 特征
     */
    public String getFeeFeature() {
        return feeFeature;
    }

    /**
     * 特征
     */
    public void setFeeFeature(String feeFeature) {
        this.feeFeature = feeFeature;
    }
    /**
     * 税率
     */
    public BigDecimal getFeeTaxRate() {
        return feeTaxRate;
    }

    /**
     * 税率
     */
    public void setFeeTaxRate(BigDecimal feeTaxRate) {
        this.feeTaxRate = feeTaxRate;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 合价(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 备注
     */
    public String getFeeMemo() {
        return feeMemo;
    }

    /**
     * 备注
     */
    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    
}
