package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 洽商签证索赔
 * 
 * @author generator
 * 
 */
 @TableName("ejc_steel_claim")
public class ClaimEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="claim_title")
    private String claimTitle; // 洽商签证索赔标题
    @TableField(value="negotiate_type_id")
    private Long negotiateTypeId; // 洽商类型
    @TableField(value="visa_type_id")
    private Long visaTypeId; // 签证类型
    @TableField(value="claim_type_id")
    private Long claimTypeId; // 索赔类型
    @TableField(value="type_name")
    private String typeName; // 洽商签证索赔类型名称
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 税率
    @TableField(value="claim_mny")
    private java.math.BigDecimal claimMny; // 洽商签证索赔金额(无税)
    @TableField(value="claim_tax_mny")
    private java.math.BigDecimal claimTaxMny; // 洽商签证索赔金额
    @TableField(value="claim_tax")
    private java.math.BigDecimal claimTax; // 洽商签证索赔金额税额
    @TableField(value="submit_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date submitDate; // 提交甲方日期
    @TableField(value="reply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date replyDate; // 甲方批复日期
    @TableField(value="reply_status")
    private String replyStatus; // 甲方批复状态(0-未通过，1-未批复，2-已批复)
    @TableField(value="reply_mny")
    private java.math.BigDecimal replyMny; // 甲方批复金额(无税)
    @TableField(value="reply_tax_mny")
    private java.math.BigDecimal replyTaxMny; // 甲方批复金额
    @TableField(value="reply_tax")
    private java.math.BigDecimal replyTax; // 甲方批复金额税额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="claim_instruction")
    private String claimInstruction; // 洽商签证索赔说明
    @TableField(value="bill_type")
    private String billType; // 单据类型(QS-洽商，QZ-签证，SP-索赔)
    @TableField(value="commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String commitDate; // 提交日期
    @TableField(value="claim_duration")
    private Integer claimDuration; // 索赔工期
    @TableField(value="reply_duration")
    private Integer replyDuration; // 批复工期

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    @TableField(value = "cost_adjust_id")
    private Long costAdjustId; // 工程造价调整申请单据id


    @TableField(value="replay_state")
    private Integer replayState; // 是否进行甲方批复
    @TableField(value="is_replay_bill")
    private Integer isReplayBill; // 是否甲方批复单据

    @TableField(value="replay_bill_id")
    private Long replayBillId; // 甲方批复单据id/主单据id
    @TableField(value="bill_source_type")
    private Integer billSourceType; // 变更洽商来源（1：甲方，2：其他）
    @TableField(value="replay_bill_type")
    private Integer replayBillType; // 甲方批复单据类型（0：批复，1：确认）
    @TableField(value="claim_type")
    private String claimType; // 二次经营分类

    public String getClaimType() {
        return claimType;
    }

    public void setClaimType(String claimType) {
        this.claimType = claimType;
    }

    public Integer getReplayBillType() {
        return replayBillType;
    }

    public void setReplayBillType(Integer replayBillType) {
        this.replayBillType = replayBillType;
    }

    public Integer getBillSourceType() {
        return billSourceType;
    }

    public void setBillSourceType(Integer billSourceType) {
        this.billSourceType = billSourceType;
    }

    public Long getReplayBillId() {
        return replayBillId;
    }

    public void setReplayBillId(Long replayBillId) {
        this.replayBillId = replayBillId;
    }

    public Integer getReplayState() {
        return replayState;
    }

    public void setReplayState(Integer replayState) {
        this.replayState = replayState;
    }

    public Integer getIsReplayBill() {
        return isReplayBill;
    }

    public void setIsReplayBill(Integer isReplayBill) {
        this.isReplayBill = isReplayBill;
    }

    public Long getCostAdjustId() {
        return costAdjustId;
    }

    public void setCostAdjustId(Long costAdjustId) {
        this.costAdjustId = costAdjustId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同ID
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 洽商签证索赔标题
     */
    public String getClaimTitle() {
        return claimTitle;
    }

    /**
     * 洽商签证索赔标题
     */
    public void setClaimTitle(String claimTitle) {
        this.claimTitle = claimTitle;
    }
    /**
     * 洽商类型
     */
    public Long getNegotiateTypeId() {
        return negotiateTypeId;
    }

    /**
     * 洽商类型
     */
    public void setNegotiateTypeId(Long negotiateTypeId) {
        this.negotiateTypeId = negotiateTypeId;
    }
    /**
     * 签证类型
     */
    public Long getVisaTypeId() {
        return visaTypeId;
    }

    /**
     * 签证类型
     */
    public void setVisaTypeId(Long visaTypeId) {
        this.visaTypeId = visaTypeId;
    }
    /**
     * 索赔类型
     */
    public Long getClaimTypeId() {
        return claimTypeId;
    }

    /**
     * 索赔类型
     */
    public void setClaimTypeId(Long claimTypeId) {
        this.claimTypeId = claimTypeId;
    }
    /**
     * 洽商签证索赔类型名称
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * 洽商签证索赔类型名称
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 洽商签证索赔金额(无税)
     */
    public java.math.BigDecimal getClaimMny() {
        return claimMny;
    }

    /**
     * 洽商签证索赔金额(无税)
     */
    public void setClaimMny(java.math.BigDecimal claimMny) {
        this.claimMny = claimMny;
    }
    /**
     * 洽商签证索赔金额
     */
    public java.math.BigDecimal getClaimTaxMny() {
        return claimTaxMny;
    }

    /**
     * 洽商签证索赔金额
     */
    public void setClaimTaxMny(java.math.BigDecimal claimTaxMny) {
        this.claimTaxMny = claimTaxMny;
    }
    /**
     * 洽商签证索赔金额税额
     */
    public java.math.BigDecimal getClaimTax() {
        return claimTax;
    }

    /**
     * 洽商签证索赔金额税额
     */
    public void setClaimTax(java.math.BigDecimal claimTax) {
        this.claimTax = claimTax;
    }
    /**
     * 提交甲方日期
     */
    public java.util.Date getSubmitDate() {
        return submitDate;
    }

    /**
     * 提交甲方日期
     */
    public void setSubmitDate(java.util.Date submitDate) {
        this.submitDate = submitDate;
    }
    /**
     * 甲方批复日期
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 甲方批复日期
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未通过，1-未批复，2-已批复)
     */
    public String getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未通过，1-未批复，2-已批复)
     */
    public void setReplyStatus(String replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 甲方批复金额(无税)
     */
    public java.math.BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 甲方批复金额(无税)
     */
    public void setReplyMny(java.math.BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 甲方批复金额
     */
    public java.math.BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 甲方批复金额
     */
    public void setReplyTaxMny(java.math.BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 甲方批复金额税额
     */
    public java.math.BigDecimal getReplyTax() {
        return replyTax;
    }

    /**
     * 甲方批复金额税额
     */
    public void setReplyTax(java.math.BigDecimal replyTax) {
        this.replyTax = replyTax;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 洽商签证索赔说明
     */
    public String getClaimInstruction() {
        return claimInstruction;
    }

    /**
     * 洽商签证索赔说明
     */
    public void setClaimInstruction(String claimInstruction) {
        this.claimInstruction = claimInstruction;
    }
    /**
     * 单据类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public String getBillType() {
        return billType;
    }

    /**
     * 单据类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(String commitDate) {
        this.commitDate = commitDate;
    }

    public Integer getClaimDuration() {
        return claimDuration;
    }

    public void setClaimDuration(Integer claimDuration) {
        this.claimDuration = claimDuration;
    }

    public Integer getReplyDuration() {
        return replyDuration;
    }

    public void setReplyDuration(Integer replyDuration) {
        this.replyDuration = replyDuration;
    }

}
