package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工程造价调整-调整来源
 * 
 * @author generator
 * 
 */
 @TableName("ejc_steel_cost_adjust_detail")
public class CostAdjustDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="adjust_id")
    private Long adjustId; // 造价调整ID
    @TableField(value="claim_id")
    private Long claimId; // 洽商签证索赔ID
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="claim_title")
    private String claimTitle; // 洽商签证索赔标题
    @TableField(value="bill_type")
    private String billType; // 单据类型：QS-洽商，QZ-签证，SP-索赔
    @TableField(value="claim_mny")
    private BigDecimal claimMny; // 洽商签证索赔金额(无税)
    @TableField(value="claim_tax_mny")
    private BigDecimal claimTaxMny; // 洽商签证索赔金额
    @TableField(value="commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    
    
    

    public Long getAdjustId() {
        return adjustId;
    }

    public void setAdjustId(Long adjustId) {
        this.adjustId = adjustId;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getClaimTitle() {
        return claimTitle;
    }

    public void setClaimTitle(String claimTitle) {
        this.claimTitle = claimTitle;
    }
    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
    public BigDecimal getClaimMny() {
        return claimMny;
    }

    public void setClaimMny(BigDecimal claimMny) {
        this.claimMny = claimMny;
    }
    public BigDecimal getClaimTaxMny() {
        return claimTaxMny;
    }

    public void setClaimTaxMny(BigDecimal claimTaxMny) {
        this.claimTaxMny = claimTaxMny;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    
}
