package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工程定案
 *
 * @author generator
 *
 */
 @TableName("ejc_steel_finalized")
public class FinalizedEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同签订金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同签订金额
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 合同计价形式
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值(无税)
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值
    @TableField(value="sum_cost_mny")
    private BigDecimal sumCostMny; // 累计成本(无税)
    @TableField(value="sum_cost_tax_mny")
    private BigDecimal sumCostTaxMny; // 累计成本
    @TableField(value="sum_receipt_mny")
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    @TableField(value="sum_receipt_tax_mny")
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    @TableField(value="final_stage")
    private String finalStage; // 定案阶段：1-一审，2-二审，3-三审，4-终审
    @TableField(value="report_settle_mny")
    private BigDecimal reportSettleMny; // 报审结算金额
    @TableField(value="report_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate; // 报审日期
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 审定金额
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 审定日期
    @TableField(value="subtract_tax_rate")
    private BigDecimal subtractTaxRate; // 合同约定审减率
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 其中甲供材金额
    @TableField(value="review_subtract_rate")
    private BigDecimal reviewSubtractRate; // 审减率
    @TableField(value="review_subtract_mny")
    private BigDecimal reviewSubtractMny; // 审减金额
    @TableField(value="return_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 预计定案表返回日期
    @TableField(value="start_guarantee_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startGuaranteeDate; // 保修期起算日
    @TableField(value="end_guarantee_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endGuaranteeDate; // 防水保修期届满日
    @TableField(value="guarantee_rate")
    private BigDecimal guaranteeRate; // 保修金比例
    @TableField(value="guarantee_mny")
    private BigDecimal guaranteeMny; // 其中防水保修金额
    @TableField(value="total_economic_benefit_rate")
    private BigDecimal totalEconomicBenefitRate; // 总经济效益率
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "settle_report_id")
    private Long settleReportId; //结算报审id
    @TableField(value="check_tax_mny")
    private BigDecimal checkTaxMny; // 审定金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="report_settle_tax_mny")
    private BigDecimal reportSettleTaxMny; // 报审结算金额
    @TableField(value = "settle_name")
    private String settleName; //结算类型名称
    @TableField(value = "filing_date")
    private Date filingDate;//返还时间
    @TableField(value = "filing_status")
    private Long filingStatus;//返还状态
    @TableField(value = "filing_status_name")
    private String filingStatusName;//返还状态名称
    @TableField(value = "seal_date")
    private Date sealDate;//盖章时间
    @TableField(value = "audit_unit")
    private String auditUnit;//审核单位
    @TableField(value="finalized_name")
    private String finalizedName; // 定案名称
    @TableField(value = "gd_status")
    private String gdStatus;
    @TableField(value = "gd_date")
    private Date gdDate;
    @TableField(value = "close_flag")
    private String closeFlag;//是否已成本关门(1-是 2-否)
    @TableField(value = "pre_total_cost")
    private BigDecimal preTotalCost;//预计总成本
    public String getFinalizedName() {
        return finalizedName;
    }

    public void setFinalizedName(String finalizedName) {
        this.finalizedName = finalizedName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public String getFinalStage() {
        return finalStage;
    }

    public void setFinalStage(String finalStage) {
        this.finalStage = finalStage;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getReviewSubtractRate() {
        return reviewSubtractRate;
    }

    public void setReviewSubtractRate(BigDecimal reviewSubtractRate) {
        this.reviewSubtractRate = reviewSubtractRate;
    }
    public BigDecimal getReviewSubtractMny() {
        return reviewSubtractMny;
    }

    public void setReviewSubtractMny(BigDecimal reviewSubtractMny) {
        this.reviewSubtractMny = reviewSubtractMny;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public Date getStartGuaranteeDate() {
        return startGuaranteeDate;
    }

    public void setStartGuaranteeDate(Date startGuaranteeDate) {
        this.startGuaranteeDate = startGuaranteeDate;
    }
    public Date getEndGuaranteeDate() {
        return endGuaranteeDate;
    }

    public void setEndGuaranteeDate(Date endGuaranteeDate) {
        this.endGuaranteeDate = endGuaranteeDate;
    }
    public BigDecimal getGuaranteeRate() {
        return guaranteeRate;
    }

    public void setGuaranteeRate(BigDecimal guaranteeRate) {
        this.guaranteeRate = guaranteeRate;
    }
    public BigDecimal getGuaranteeMny() {
        return guaranteeMny;
    }

    public void setGuaranteeMny(BigDecimal guaranteeMny) {
        this.guaranteeMny = guaranteeMny;
    }

    public BigDecimal getTotalEconomicBenefitRate() {
        return totalEconomicBenefitRate;
    }

    public void setTotalEconomicBenefitRate(BigDecimal totalEconomicBenefitRate) {
        this.totalEconomicBenefitRate = totalEconomicBenefitRate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSettleReportId() {
        return settleReportId;
    }

    public void setSettleReportId(Long settleReportId) {
        this.settleReportId = settleReportId;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    public Date getFilingDate() {
        return filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }

    public Long getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Long filingStatus) {
        this.filingStatus = filingStatus;
    }

    public String getFilingStatusName() {
        return filingStatusName;
    }

    public void setFilingStatusName(String filingStatusName) {
        this.filingStatusName = filingStatusName;
    }

    public Date getSealDate() {
        return sealDate;
    }

    public void setSealDate(Date sealDate) {
        this.sealDate = sealDate;
    }

    public String getAuditUnit() {
        return auditUnit;
    }

    public void setAuditUnit(String auditUnit) {
        this.auditUnit = auditUnit;
    }

    public String getGdStatus() {
        return gdStatus;
    }

    public void setGdStatus(String gdStatus) {
        this.gdStatus = gdStatus;
    }

    public Date getGdDate() {
        return gdDate;
    }

    public void setGdDate(Date gdDate) {
        this.gdDate = gdDate;
    }

    public String getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(String closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }
}
