package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 产值报量子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_steel_production_detail")
public class ProductionDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="production_id")
    private Long productionId; // 产值进度主键
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="budget_code")
    private String budgetCode; // 预算书编号
    @TableField(value="budget_name")
    private String budgetName; // 预算书名称
    @TableField(value="budget_model")
    private Integer budgetModel; // 预算模式 0-清单模式，1-费用项目模式
    @TableField(value="budget_source")
    private String budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 税率
    @TableField(value="budget_mny")
    private java.math.BigDecimal budgetMny; // 预算金额(无税)
    @TableField(value="budget_tax_mny")
    private java.math.BigDecimal budgetTaxMny; // 预算金额
    @TableField(value="production_mny")
    private java.math.BigDecimal productionMny; // 本次产值金额(无税)
    @TableField(value="production_tax_mny")
    private java.math.BigDecimal productionTaxMny; // 本次产值金额
    @TableField(value="last_production_mny")
    private java.math.BigDecimal lastProductionMny; // 截止上期累计产值金额(无税)
    @TableField(value="last_production_tax_mny")
    private java.math.BigDecimal lastProductionTaxMny; // 截止上期累计产值金额
    @TableField(value="sum_production_mny")
    private java.math.BigDecimal sumProductionMny; // 累计产值金额(无税)
    @TableField(value="sum_production_tax_mny")
    private java.math.BigDecimal sumProductionTaxMny; // 累计产值金额
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="productionDetailCostService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.ProductionDetailCostEntity> costList = new ArrayList<>(); // 产值报量子表-费用项清单
    @TableField(exist=false)
    @SubEntity(serviceName="productionDetailSubService", pidName = "detailId")
    private List<ProductionDetailSubEntity> subList = new ArrayList<>(); // 产值报量子表-分部分项清单
    @TableField(exist=false)
    @SubEntity(serviceName="productionDetailMeasureService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.ProductionDetailMeasureEntity> measureList = new ArrayList<>(); // 产值报量子表-措施项清单
    @TableField(exist=false)
    @SubEntity(serviceName="productionDetailOtherService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.ProductionDetailOtherEntity> otherList = new ArrayList<>(); // 产值报量子表-其他项清单
    @TableField(exist=false)
    @SubEntity(serviceName="productionDetailFeeService", pidName = "detailId")
    private List<ProductionDetailFeeEntity> feeList = new ArrayList<>(); // 产值报量子表-费税清单
    

    /**
     * 产值进度主键
     */
    public Long getProductionId() {
        return productionId;
    }

    /**
     * 产值进度主键
     */
    public void setProductionId(Long productionId) {
        this.productionId = productionId;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 预算书编号
     */
    public String getBudgetCode() {
        return budgetCode;
    }

    /**
     * 预算书编号
     */
    public void setBudgetCode(String budgetCode) {
        this.budgetCode = budgetCode;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public String getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(String budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 预算金额(无税)
     */
    public java.math.BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额(无税)
     */
    public void setBudgetMny(java.math.BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 预算金额
     */
    public java.math.BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetTaxMny(java.math.BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 本次产值金额(无税)
     */
    public java.math.BigDecimal getProductionMny() {
        return productionMny;
    }

    /**
     * 本次产值金额(无税)
     */
    public void setProductionMny(java.math.BigDecimal productionMny) {
        this.productionMny = productionMny;
    }
    /**
     * 本次产值金额
     */
    public java.math.BigDecimal getProductionTaxMny() {
        return productionTaxMny;
    }

    /**
     * 本次产值金额
     */
    public void setProductionTaxMny(java.math.BigDecimal productionTaxMny) {
        this.productionTaxMny = productionTaxMny;
    }
    /**
     * 截止上期累计产值金额(无税)
     */
    public java.math.BigDecimal getLastProductionMny() {
        return lastProductionMny;
    }

    /**
     * 截止上期累计产值金额(无税)
     */
    public void setLastProductionMny(java.math.BigDecimal lastProductionMny) {
        this.lastProductionMny = lastProductionMny;
    }
    /**
     * 截止上期累计产值金额
     */
    public java.math.BigDecimal getLastProductionTaxMny() {
        return lastProductionTaxMny;
    }

    /**
     * 截止上期累计产值金额
     */
    public void setLastProductionTaxMny(java.math.BigDecimal lastProductionTaxMny) {
        this.lastProductionTaxMny = lastProductionTaxMny;
    }
    /**
     * 累计产值金额(无税)
     */
    public java.math.BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值金额(无税)
     */
    public void setSumProductionMny(java.math.BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计产值金额
     */
    public java.math.BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值金额
     */
    public void setSumProductionTaxMny(java.math.BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 产值报量子表-费用项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.ProductionDetailCostEntity> getCostList() {
        return costList;
    }

    /**
     * 产值报量子表-费用项清单
     */
    public void setCostList(List<com.ejianc.business.steelstructure.income.bean.ProductionDetailCostEntity> costList) {
        this.costList = costList;
    }
    /**
     * 产值报量子表-分部分项清单
     */
    public List<ProductionDetailSubEntity> getSubList() {
        return subList;
    }

    /**
     * 产值报量子表-分部分项清单
     */
    public void setSubList(List<ProductionDetailSubEntity> subList) {
        this.subList = subList;
    }
    /**
     * 产值报量子表-措施项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.ProductionDetailMeasureEntity> getMeasureList() {
        return measureList;
    }

    /**
     * 产值报量子表-措施项清单
     */
    public void setMeasureList(List<com.ejianc.business.steelstructure.income.bean.ProductionDetailMeasureEntity> measureList) {
        this.measureList = measureList;
    }
    /**
     * 产值报量子表-其他项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.ProductionDetailOtherEntity> getOtherList() {
        return otherList;
    }

    /**
     * 产值报量子表-其他项清单
     */
    public void setOtherList(List<com.ejianc.business.steelstructure.income.bean.ProductionDetailOtherEntity> otherList) {
        this.otherList = otherList;
    }
    /**
     * 产值报量子表-费税清单
     */
    public List<ProductionDetailFeeEntity> getFeeList() {
        return feeList;
    }

    /**
     * 产值报量子表-费税清单
     */
    public void setFeeList(List<ProductionDetailFeeEntity> feeList) {
        this.feeList = feeList;
    }
}
