package com.ejianc.business.steelstructure.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 对甲报量子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_steel_quote_detail")
public class QuoteDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="quote_id")
    private Long quoteId; // 甲方报量主键
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="budget_code")
    private String budgetCode; // 预算书编号
    @TableField(value="budget_name")
    private String budgetName; // 预算书名称
    @TableField(value="budget_model")
    private Integer budgetModel; // 预算模式 0-清单模式，1-费用项目模式
    @TableField(value="budget_source")
    private String budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 税率
    @TableField(value="budget_mny")
    private java.math.BigDecimal budgetMny; // 预算金额(无税)
    @TableField(value="budget_tax_mny")
    private java.math.BigDecimal budgetTaxMny; // 预算金额
    @TableField(value="quote_mny")
    private java.math.BigDecimal quoteMny; // 本次上报金额(无税)
    @TableField(value="quote_tax_mny")
    private java.math.BigDecimal quoteTaxMny; // 本次上报金额
    @TableField(value="last_quote_mny")
    private java.math.BigDecimal lastQuoteMny; // 截止上期累计上报金额(无税)
    @TableField(value="last_quote_tax_mny")
    private java.math.BigDecimal lastQuoteTaxMny; // 截止上期累计上报金额
    @TableField(value="sum_quote_mny")
    private java.math.BigDecimal sumQuoteMny; // 累计上报金额(无税)
    @TableField(value="sum_quote_tax_mny")
    private java.math.BigDecimal sumQuoteTaxMny; // 累计上报金额
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailCostService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.QuoteDetailCostEntity> costList = new ArrayList<>(); // 对甲报量子表-费用项清单
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailSubService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.QuoteDetailSubEntity> subList = new ArrayList<>(); // 对甲报量子表-分部分项清单
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailMeasureService", pidName = "detailId")
    private List<com.ejianc.business.steelstructure.income.bean.QuoteDetailMeasureEntity> measureList = new ArrayList<>(); // 对甲报量子表-措施项清单
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailOtherService", pidName = "detailId")
    private List<QuoteDetailOtherEntity> otherList = new ArrayList<>(); // 对甲报量子表-其他项清单
    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailFeeService", pidName = "detailId")
    private List<QuoteDetailFeeEntity> feeList = new ArrayList<>(); // 对甲报量子表-费税清单
    

    /**
     * 甲方报量主键
     */
    public Long getQuoteId() {
        return quoteId;
    }

    /**
     * 甲方报量主键
     */
    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 预算书编号
     */
    public String getBudgetCode() {
        return budgetCode;
    }

    /**
     * 预算书编号
     */
    public void setBudgetCode(String budgetCode) {
        this.budgetCode = budgetCode;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public String getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(String budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 预算金额(无税)
     */
    public java.math.BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额(无税)
     */
    public void setBudgetMny(java.math.BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 预算金额
     */
    public java.math.BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetTaxMny(java.math.BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 本次上报金额(无税)
     */
    public java.math.BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(java.math.BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public java.math.BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(java.math.BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 截止上期累计上报金额(无税)
     */
    public java.math.BigDecimal getLastQuoteMny() {
        return lastQuoteMny;
    }

    /**
     * 截止上期累计上报金额(无税)
     */
    public void setLastQuoteMny(java.math.BigDecimal lastQuoteMny) {
        this.lastQuoteMny = lastQuoteMny;
    }
    /**
     * 截止上期累计上报金额
     */
    public java.math.BigDecimal getLastQuoteTaxMny() {
        return lastQuoteTaxMny;
    }

    /**
     * 截止上期累计上报金额
     */
    public void setLastQuoteTaxMny(java.math.BigDecimal lastQuoteTaxMny) {
        this.lastQuoteTaxMny = lastQuoteTaxMny;
    }
    /**
     * 累计上报金额(无税)
     */
    public java.math.BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计上报金额(无税)
     */
    public void setSumQuoteMny(java.math.BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计上报金额
     */
    public java.math.BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计上报金额
     */
    public void setSumQuoteTaxMny(java.math.BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 对甲报量子表-费用项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.QuoteDetailCostEntity> getCostList() {
        return costList;
    }

    /**
     * 对甲报量子表-费用项清单
     */
    public void setCostList(List<com.ejianc.business.steelstructure.income.bean.QuoteDetailCostEntity> costList) {
        this.costList = costList;
    }
    /**
     * 对甲报量子表-分部分项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.QuoteDetailSubEntity> getSubList() {
        return subList;
    }

    /**
     * 对甲报量子表-分部分项清单
     */
    public void setSubList(List<com.ejianc.business.steelstructure.income.bean.QuoteDetailSubEntity> subList) {
        this.subList = subList;
    }
    /**
     * 对甲报量子表-措施项清单
     */
    public List<com.ejianc.business.steelstructure.income.bean.QuoteDetailMeasureEntity> getMeasureList() {
        return measureList;
    }

    /**
     * 对甲报量子表-措施项清单
     */
    public void setMeasureList(List<com.ejianc.business.steelstructure.income.bean.QuoteDetailMeasureEntity> measureList) {
        this.measureList = measureList;
    }
    /**
     * 对甲报量子表-其他项清单
     */
    public List<QuoteDetailOtherEntity> getOtherList() {
        return otherList;
    }

    /**
     * 对甲报量子表-其他项清单
     */
    public void setOtherList(List<QuoteDetailOtherEntity> otherList) {
        this.otherList = otherList;
    }
    /**
     * 对甲报量子表-费税清单
     */
    public List<QuoteDetailFeeEntity> getFeeList() {
        return feeList;
    }

    /**
     * 对甲报量子表-费税清单
     */
    public void setFeeList(List<QuoteDetailFeeEntity> feeList) {
        this.feeList = feeList;
    }
}
