package com.ejianc.business.steelstructure.income.cons;

import java.util.HashMap;
import java.util.Map;

public class CommonConstants {

    public static final String QS = "1"; //变更洽商
    public static final String QZ = "2"; //经济签证
    public static final String SP = "3"; //索赔

    public static final String WPF = "0"; //未批复
    public static final String YPF = "1"; //已批复
    public static final String WTG = "2"; //未通过
    public static final String WU = "3"; //无

    public static final Map<String,String> REPLY_STATUS_MAP = new HashMap<>();

    static {
        REPLY_STATUS_MAP.put(WPF,"未批复");
        REPLY_STATUS_MAP.put(YPF,"已批复");
        REPLY_STATUS_MAP.put(WTG,"未通过");
        REPLY_STATUS_MAP.put(WU,"无");
    }

    /**
     * 变更签证索赔记录 关闭状态
     */
    public static final Integer CLOSE = 1;

    /**
     * 变更签证索赔记录 开启状态
     */
    public static final Integer OPEN = 0;

    /**
     * 变更签证索赔记录 未引用
     */
    public static final Integer WYY = 0;

    /**
     * 变更签证索赔记录 受理中
     */
    public static final Integer SLZ = 1;

    /**
     * 变更签证索赔记录 已受理
     */
    public static final Integer YSL = 2;

    public static final Map<Integer,String> QUOTE_STATUS_MAP = new HashMap<>();

    static {
        QUOTE_STATUS_MAP.put(WYY,"未引用");
        QUOTE_STATUS_MAP.put(SLZ,"受理中");
        QUOTE_STATUS_MAP.put(YSL,"已受理");
    }

}
