package com.ejianc.business.steelstructure.income.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.income.bean.BudgetCategoryEntity;
import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.service.IBudgetCategoryService;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.vo.BudgetCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 预算分类
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("budgetCategory")
public class BudgetCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;


    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBudgetCategoryService service;

    @Autowired
    private IBudgetService budgetService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> saveOrUpdate(@RequestBody BudgetCategoryVO saveorUpdateVO) {
    	BudgetCategoryEntity entity = BeanMapper.map(saveorUpdateVO, BudgetCategoryEntity.class);
        recalibration(entity);
    	service.saveOrUpdate(entity, false);
    	BudgetCategoryVO vo = BeanMapper.map(entity, BudgetCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> queryDetail(Long id) {
    	BudgetCategoryEntity entity = service.selectById(id);
    	BudgetCategoryVO vo = BeanMapper.map(entity, BudgetCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetCategoryVO> vos) {
        LambdaQueryWrapper<BudgetCategoryEntity> query = new LambdaQueryWrapper<>();
        boolean flag = false;
        for (BudgetCategoryVO vo : vos){
            if (vo.getIncomeFlag() == 1){
                flag = true;
                LambdaQueryWrapper<BudgetEntity> queryWrapper = new LambdaQueryWrapper<>();
                //queryWrapper.eq(BudgetEntity::getProjectId,vo.getProjectId());
                queryWrapper.eq(BudgetEntity::getBudgetCategoryId,vo.getId());
                queryWrapper.eq(BudgetEntity::getDr,0);
                queryWrapper.eq(BudgetEntity::getTenantId, InvocationInfoProxy.getTenantid());
                queryWrapper.eq(BudgetEntity::getIncomeFlag,1);
                List<BudgetEntity> entities = budgetService.list(queryWrapper);
                if (CollectionUtils.isNotEmpty(entities) ){
                    throw new BusinessException("删除失败！该预算分类已被引用，不允许删除");
                }
            }
            //query.eq(BudgetCategoryEntity::getProjectId,vo.getProjectId());
            query.eq(BudgetCategoryEntity::getDr,0);
            query.eq(BudgetCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        }
        service.removeByIds(vos.stream().map(BudgetCategoryVO::getId).collect(Collectors.toList()),true);
        if(flag){
            List<BudgetCategoryEntity> entityList = service.list(query);
            if (CollectionUtils.isNotEmpty(entityList)){
                entityList.get(0).setIncomeFlag(1);
                service.updateById(entityList.get(0));
            }
        }
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetCategoryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
        IPage<BudgetCategoryEntity> page = service.queryPage(param,false);
//        if (param.getParams().get("projectId") == null){
//            IPage<BudgetCategoryVO> pageData = new Page<>();
//            return CommonResponse.success("查询列表数据成功！",pageData);
//        }
        IPage<BudgetCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetCategoryVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<BudgetCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetCategory-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refBudgetCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetCategoryVO>> refBudgetCategoryData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                         @RequestParam(defaultValue = "10") Integer pageSize,
                                                                         @RequestParam(value = "searchText", required = false) String searchText,
                                                                         @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if (StringUtils.isNotEmpty(condition)) {
//            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
//            if (null != conditionMap.get("projectId")) {
//                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
//                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//            }
//        }
        IPage<BudgetCategoryEntity> page = service.queryPage(param, false);
        IPage<BudgetCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BudgetCategoryVO> BudgetCategoryVOS = BeanMapper.mapList(page.getRecords(), BudgetCategoryVO.class);
        BudgetCategoryVOS.forEach(e -> {
            if (e.getIncomeFlag()==1){
                e.setIncomeFlagName("是");
            }else{
                e.setIncomeFlagName("否");
            }
        });
        pageData.setRecords(BudgetCategoryVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    //编辑预算分类
    @PostMapping("updateReplyDate")
    @ResponseBody
    public CommonResponse<String> updateReplyDate(@RequestBody BudgetCategoryVO budgetCategory){
        BudgetCategoryEntity entity = BeanMapper.map(budgetCategory, BudgetCategoryEntity.class);
        BudgetCategoryEntity budgetCategoryEntity = service.selectById(budgetCategory.getId());
        if(budgetCategory.getIncomeFlag() == 1){
            LambdaQueryWrapper<BudgetEntity> queryWrapper = new LambdaQueryWrapper<>();
            //queryWrapper.eq(BudgetEntity::getProjectId,budgetCategoryEntity.getProjectId());
            queryWrapper.eq(BudgetEntity::getBudgetCategoryId,budgetCategory.getId());
            queryWrapper.eq(BudgetEntity::getDr,0);
            queryWrapper.eq(BudgetEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.eq(BudgetEntity::getIncomeFlag,1);
            List<BudgetEntity> entityList = budgetService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(entityList)){
                throw new BusinessException("编辑失败！该预算分类已被引用，不允许编辑");
            }
        }
        recalibration(entity);
        if (budgetCategoryEntity!=null){
            LambdaUpdateWrapper<BudgetCategoryEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BudgetCategoryEntity::getId,budgetCategory.getId());
            wrapper.set(BudgetCategoryEntity::getCode,budgetCategory.getCode());
            wrapper.set(BudgetCategoryEntity::getName,budgetCategory.getName());
            wrapper.set(BudgetCategoryEntity::getMemo,budgetCategory.getMemo());
            service.update(wrapper);
            return CommonResponse.success();
        }else{
            return CommonResponse.error("单据不存在！");
        }
    }

    /**
     * @Description flag 是否收入按钮
     */
    @RequestMapping(value = "/flag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> flag(@RequestBody BudgetCategoryVO vos) {
        BudgetCategoryEntity entity = BeanMapper.map(vos, BudgetCategoryEntity.class);
//        LambdaQueryWrapper<BudgetEntity> queryWrapper = new LambdaQueryWrapper<>();
//        //queryWrapper.eq(BudgetEntity::getProjectId,entity.getProjectId());
//        queryWrapper.eq(BudgetEntity::getBudgetCategoryId,vos.getId());
//        queryWrapper.eq(BudgetEntity::getDr,0);
//        queryWrapper.eq(BudgetEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        queryWrapper.eq(BudgetEntity::getIncomeFlag,1);
//        List<BudgetEntity> entityList = budgetService.list(queryWrapper);
//        if (CollectionUtils.isNotEmpty(entityList)){
//            throw new BusinessException("修改失败！该预算分类已被引用，不允许修改");
//        }
        if (vos.getIncomeFlag() == 1){
            LambdaUpdateWrapper<BudgetCategoryEntity> updateData = new LambdaUpdateWrapper();
            updateData.set(BudgetCategoryEntity::getIncomeFlag, 0);
            //updateData.eq(BudgetCategoryEntity::getProjectId,vos.getProjectId());
            updateData.ne(BudgetCategoryEntity::getId,vos.getId());
            service.update(updateData);
        }else {
            throw new BusinessException("是否收入至少一个为是");
        }
        service.saveOrUpdate(entity, false);
        BudgetCategoryVO vo = BeanMapper.map(entity, BudgetCategoryVO.class);
        return CommonResponse.success("修改成功！", vo);
    }
//查询收入为是的数据
    @RequestMapping(value = "/getIncome", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> getIncome() {
        LambdaQueryWrapper<BudgetCategoryEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetCategoryEntity::getDr,0);
        queryWrapper.eq(BudgetCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetCategoryEntity::getIncomeFlag,1);
        queryWrapper.last("LIMIT 1");
        BudgetCategoryEntity entity = service.getOne(queryWrapper);
        BudgetCategoryVO vo = null;
        if (entity!=null){
            vo = BeanMapper.map(entity,BudgetCategoryVO.class);
        }
        return CommonResponse.success("查询成功！",vo);
    }

    public void recalibration(BudgetCategoryEntity entity){
        LambdaQueryWrapper<BudgetCategoryEntity> lambda = new LambdaQueryWrapper<>();
        //lambda.eq(BudgetCategoryEntity::getProjectId,entity.getProjectId());
        lambda.eq(BudgetCategoryEntity::getDr,0);
        lambda.eq(BudgetCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(BudgetCategoryEntity::getCode,entity.getCode());
        List<BudgetCategoryEntity> entities1 = service.list(lambda);
        if(entities1.size() !=0){
            throw new BusinessException("编码不能重复");
        }
        LambdaQueryWrapper<BudgetCategoryEntity> wrapper = new LambdaQueryWrapper<>();
        //wrapper.eq(BudgetCategoryEntity::getProjectId,entity.getProjectId());
        wrapper.eq(BudgetCategoryEntity::getDr,0);
        wrapper.eq(BudgetCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.eq(BudgetCategoryEntity::getName,entity.getName());
        List<BudgetCategoryEntity> entities = service.list(wrapper);
        if(entities.size() != 0){
            throw new BusinessException("名称不能重复");
        }
    }
}
