package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.steelstructure.income.service.IContractRegisterChangeService;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterChangeVO;
import com.ejianc.business.steelstructure.income.vo.RegisterChangeHistoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 合同登记变更
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("contractRegisterChange")
public class ContractRegisterChangeController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private IContractRegisterChangeService service;


    @Autowired
    private IPMContractApi contractApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractRegisterChangeVO> saveOrUpdate(@RequestBody ContractRegisterChangeVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterChangeVO> queryDetail(Long id) {
    	ContractRegisterChangeEntity entity = service.selectById(id);
    	ContractRegisterChangeVO vo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterChangeVO> vos) {
        service.deleteChange(vos);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ContractRegisterChangeEntity> page = service.queryPage(param,false);
        IPage<ContractRegisterChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterChangeVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractRegisterChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractRegisterChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refContractRegisterChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterChangeVO>> refContractRegisterChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContractRegisterChangeEntity> page = service.queryPage(param,false);
        IPage<ContractRegisterChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 新增变更时根据合同id查询详情
     * @param registerId
     * @return
     */
    @RequestMapping(value = "/addChangeByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterChangeVO> addChangeByConId(Long registerId) {
        ContractRegisterChangeVO vo = service.addChangeByConId(registerId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterChangeHistoryVO> queryChangeRecord(@RequestParam Long id) {
        RegisterChangeHistoryVO vo = service.queryChangeRecord(id);
        return CommonResponse.success(vo);
    }


    /**
     * 推送至财务中间库
     * @param
     * @return
     */
    @GetMapping(value = "/pushToCw")
    @ResponseBody
    public CommonResponse<ContractRegisterChangeVO> pushToCw(@RequestParam(value = "contractId") Long contractId) {
        ContractRegisterChangeEntity entity = service.getById(contractId);
        CommonResponse<List<PMContractVO>> listCommonResponse = contractApi.queryDetail(String.valueOf(contractId), 0);
        if (listCommonResponse.getCode() == 0) {
            if (listCommonResponse.getData().size() > 0) {
                throw new BusinessException("此合同财务中间库中已存在！");
            }
            return service.pushToCw(entity);
        }else {
            return CommonResponse.error(listCommonResponse.getMsg());
        }


    }
}
