package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.business.steelstructure.income.bean.ContractConfessEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.service.IContractConfessService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.utils.DateUtil;
import com.ejianc.business.steelstructure.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同评审
 *
 * @author generator
 */
@Controller
@RequestMapping("contractReview")
public class ContractReviewController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractReviewService service;

    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IContractConfessService contractConfessService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractReviewVO> saveOrUpdate(@RequestBody ContractReviewVO saveorUpdateVO) {

        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * 新增补充协议评审时根据合同id查询详情
     *
     * @param mainContractId
     * @return
     */
    @RequestMapping(value = "/addSupplementByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractReviewVO> addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = service.addSupplementByConId(mainContractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * 修改合同时根据合同id查询详情
     *
     * @param oldId
     * @return
     */
    @RequestMapping(value = "/editContractByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractReviewVO> editContractByConId(Long oldId) {
        ContractReviewVO contractReviewVO = service.editContractByConId(oldId);
        return CommonResponse.success("新增转换数据成功！", contractReviewVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractReviewVO> vos) {
        for (ContractReviewVO vo : vos) {
            ContractReviewEntity entity = service.getById(vo.getId());
            if (entity.getOldReviewCode() != null) {
                LambdaQueryWrapper<ContractReviewEntity> wrapper = Wrappers.<ContractReviewEntity>lambdaQuery();
                wrapper.eq(ContractReviewEntity::getBillCode, entity.getOldReviewCode());
                ContractReviewEntity contractReviewEntity = service.getOne(wrapper);
                contractReviewEntity.setUseStatus(1);
                service.saveOrUpdate(contractReviewEntity);
            }
        }
        service.removeByIds(vos.stream().map(ContractReviewVO::getId).collect(Collectors.toList()), true);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractReviewVO> list = service.excelExport(param);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        ExcelExport.getInstance().export("contract-review-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     * @Description 参照
     */
    @RequestMapping(value = "/refContractReviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractReviewVO>> refContractReviewData(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        // 过滤掉已经做过登记的评审
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();

        if (StringUtils.isNotEmpty(condition))  {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (!Objects.equals(conditionMap.get("projectId"), null)) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                wrapper.eq(ContractRegisterEntity::getProjectId, projectId);
            }
            if (!Objects.equals(conditionMap.get("supplementFlag"), null)) {
                int supplementFlag = Integer.parseInt(conditionMap.get("supplementFlag").toString());
                param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, supplementFlag));
            }
            if (!Objects.equals(conditionMap.get("mainContractId"), null)) {
                Long mainContractId = Long.valueOf(conditionMap.get("mainContractId").toString());
                // 根据主合同查询出来对应的评审id
                ContractRegisterEntity registerEntity = registerService.selectById(mainContractId);
                if (!Objects.equals(null, registerEntity.getReviewId())) {
                    param.getParams().put("mainContractId", new Parameter(QueryParam.EQ, registerEntity.getReviewId()));
                }
            }
            //过滤在用状态为在用的(1为在用2为废弃)
            if (!Objects.equals(conditionMap.get("useStatus"), null)) {
                Integer useStatus = Integer.valueOf(conditionMap.get("useStatus").toString());
                param.getParams().put("useStatus", new Parameter(QueryParam.EQ, useStatus));
            }
        }

        List<ContractRegisterEntity> list = registerService.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            List<Long> reviewIdList = list.stream().map(ContractRegisterEntity::getReviewId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (ListUtil.isNotEmpty(reviewIdList)) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, reviewIdList));
            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractReviewEntity> page = service.queryPage(param, false);
        IPage<ContractReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractReviewVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     * @Description 参照
     */
    @RequestMapping(value = "/refContractReviewDataAll", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractReviewVO>> refContractReviewDataAl(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        // 过滤掉已经做过登记的评审
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();

        if (StringUtils.isNotEmpty(condition))  {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (!Objects.equals(conditionMap.get("projectId"), null)) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                wrapper.eq(ContractRegisterEntity::getProjectId, projectId);
            }
            if (!Objects.equals(conditionMap.get("supplementFlag"), null)) {
                int supplementFlag = Integer.parseInt(conditionMap.get("supplementFlag").toString());
                param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, supplementFlag));
            }
            if (!Objects.equals(conditionMap.get("mainContractId"), null)) {
                Long mainContractId = Long.valueOf(conditionMap.get("mainContractId").toString());
                // 根据主合同查询出来对应的评审id
                ContractRegisterEntity registerEntity = registerService.selectById(mainContractId);
                if (!Objects.equals(null, registerEntity.getReviewId())) {
                    param.getParams().put("mainContractId", new Parameter(QueryParam.EQ, registerEntity.getReviewId()));
                }
            }
            //过滤在用状态为在用的(1为在用2为废弃)
            if (!Objects.equals(conditionMap.get("useStatus"), null)) {
                Integer useStatus = Integer.valueOf(conditionMap.get("useStatus").toString());
                param.getParams().put("useStatus", new Parameter(QueryParam.EQ, useStatus));
            }
        }


        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractReviewEntity> page = service.queryPage(param, false);
        IPage<ContractReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractReviewVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    /**
     * 评审关联项目
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/relationProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> relationProject(@RequestBody ContractReviewVO vo) {
        service.relationProject(vo);
        return CommonResponse.success("关联项目成功！");
    }

    /**
     * 校验一个项目下只有一个评审
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/validateReview")
    @ResponseBody
    public CommonResponse<Boolean> validateReview(Long projectId, Long id) {
       service.validateReview(projectId, id);
        return CommonResponse.success("关联项目成功！");
    }



    /**
     * @param timeFlag
     * @Description getBidBase 经营门户-合同管理一览
     */
    @RequestMapping(value = "/getContractBase", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getContractBase(String timeFlag, Long orgId) {
        List<ResultVO> resultVOS = new ArrayList<>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        /**
         * 施工合同评审数量:
         *      1.合同类型是正式合同、重大补充协议、单独补充协议且；
         *      2.评审类型为正常评审；
         *      3.审批通过抓取的数量；
         *      4.本年；
         *      5.组织过滤；
         *      6.在用；
         */
        QueryWrapper<ContractReviewEntity> reviewQueryWrapper = new QueryWrapper<>();
        reviewQueryWrapper.in("org_id",orgIdList);//组织过滤
        reviewQueryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        reviewQueryWrapper.eq("thisYear".equals(timeFlag), "YEAR(create_time)", DateUtil.getYear());
        reviewQueryWrapper.eq("use_status", 1);//在用状态为在用

        //合同类型
        List<Long> contractType = new ArrayList<>();
        contractType.add(1470956512901578754L);//正式合同
        contractType.add(1514498764393730049L);//重大补充协议
        contractType.add(1470957043971768321L);//单独核算补充协议
        contractType.add(1505845046831124481l);//小合同
        reviewQueryWrapper.in("contract_type", contractType);


        //评审类型
//        List<Long> approveType = new ArrayList<>();
//        approveType.add(1592044817888579585L);//正常评审
//        reviewQueryWrapper.in("approve_type", approveType);

        List<ContractReviewEntity> contractReviewEntities = service.list(reviewQueryWrapper);
        ResultVO contractReviewResultVO = new ResultVO("施工合同评审数量", contractReviewEntities.size());

        /**
         *  施工合同返还数量:
         *          正式施工合同登记审批通过的数量;
         */
        QueryWrapper<ContractRegisterEntity> registerQueryWrapper = new QueryWrapper<>();
        registerQueryWrapper.in("org_id",orgIdList);//组织过滤
        registerQueryWrapper.in("contract_type",contractType);//组织过滤
        registerQueryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        registerQueryWrapper.eq("thisYear".equals(timeFlag), "YEAR(create_time)", DateUtil.getYear());
        registerQueryWrapper.in("is_estimation", Arrays.asList(0));
        List<ContractRegisterEntity> registerEntities = registerService.list(registerQueryWrapper);
        ResultVO registerResultVO = new ResultVO("施工合同返还数量", registerEntities.size());


        /**
         *  施工合同交底数量:
         *          集团施工合同交底审批通过的数量;
         */
        QueryWrapper<ContractConfessEntity> confessQueryWrapper = new QueryWrapper<>();
        confessQueryWrapper.in("org_id",orgIdList);//组织过滤
        confessQueryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        confessQueryWrapper.eq("thisYear".equals(timeFlag), "YEAR(confess_date)", DateUtil.getYear());
        confessQueryWrapper.eq("bill_type", 1);//集团施工合同交底

        List<ContractConfessEntity> confessEntities = contractConfessService.list(confessQueryWrapper);
        ResultVO confessResultVO = new ResultVO("集团施工合同交底数量", confessEntities.size());

        resultVOS.add(contractReviewResultVO);
        resultVOS.add(registerResultVO);
        resultVOS.add(confessResultVO);

        return CommonResponse.success(resultVOS);
    }
}
