package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.income.bean.CostAdjustEntity;
import com.ejianc.business.steelstructure.income.enums.BillStateEnum;
import com.ejianc.business.steelstructure.income.service.ICostAdjustService;
import com.ejianc.business.steelstructure.income.vo.ClaimVO;
import com.ejianc.business.steelstructure.income.vo.CostAdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工程造价调整
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costAdjust")
public class CostAdjustController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private ICostAdjustService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostAdjustVO> saveOrUpdate(@RequestBody CostAdjustVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostAdjustVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostAdjustVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CostAdjustVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CostAdjustVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostAdjustVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<CostAdjustEntity> page = service.queryPage(param,false);
        IPage<CostAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostAdjustVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        List<CostAdjustEntity> list = service.queryList(param);
        List<CostAdjustVO> voList = BeanMapper.mapList(list, CostAdjustVO.class);
        for (CostAdjustVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("cost-adjust-export.xlsx", beans, response);
    }
    
    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refCostAdjustData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostAdjustVO>> refCostAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostAdjustEntity> page = service.queryPage(param,false);
        IPage<CostAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostAdjustVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
     
    /**
     * 校验合同
     * @param contractId 
     * @param id
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> validateContract(Long contractId, Long id) {
        return CommonResponse.success("校验成功！", service.validateContract(contractId, id));
    }
    
    /**
     * 根绝合同查询相关金额
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostAdjustVO> queryMny(Long contractId) {
        return CommonResponse.success("查询成功！", service.queryMny(contractId));
    }

    /**
     * 根绝合同查询二次经营数据
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryClaimList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ClaimVO>> queryClaimList(Long contractId, String applyAdjustDate, String lastApplyAdjustDate) {
        return CommonResponse.success("查询成功！", service.queryClaimList(contractId, applyAdjustDate, lastApplyAdjustDate));
    }
     
}
