package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.business.steelstructure.income.bean.ProjectSetEntity;
import com.ejianc.business.steelstructure.income.bean.SummaryEntity;
import com.ejianc.business.steelstructure.income.consts.BidCommonConsts;
import com.ejianc.business.steelstructure.income.consts.BidStateEnum;
import com.ejianc.business.steelstructure.income.consts.BiddingFormEnum;
import com.ejianc.business.steelstructure.income.service.ISummaryService;
import com.ejianc.business.steelstructure.income.utils.DateUtil;
import com.ejianc.business.steelstructure.income.vo.InfoTrackVO;
import com.ejianc.business.steelstructure.income.bean.InfoTrackEntity;
import com.ejianc.business.steelstructure.income.service.IInfoTrackService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标信息跟踪
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("infoTrack")
@Api(value = "投标信息跟踪", tags = {"投标信息跟踪"})
public class InfoTrackController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    /**此处需要根据实际修改 */
    private static final String BILL_CODE = "BID_ENGINEERING_CODE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInfoTrackService service;
    /*@Autowired
    private IRecordService recordService;*/
    /*@Autowired
    private IInfoTrackStopService infoTrackStopService;*/


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InfoTrackVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody InfoTrackVO saveorUpdateVO) {
    	InfoTrackEntity entity = BeanMapper.map(saveorUpdateVO, InfoTrackEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
    	if (entity.getId() == null || entity.getId() == 0) {
            //新增 默认未中止 0
            entity.setIsStop(BidCommonConsts.NO);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //此处需要根据实际修改 删除本行或者上一行
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            entity.setUpdateUserCode(userContextCache.getUserCode());
            entity.setUpdateTime(new Date());
        }
    	service.saveOrUpdate(entity, false);
    	InfoTrackVO vo = BeanMapper.map(entity, InfoTrackVO.class);
        //infoTrackStopService.insertInfoTrackStop(vo);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InfoTrackVO> queryDetail(@RequestParam Long id) {
    	InfoTrackEntity entity = service.selectById(id);
    	InfoTrackVO vo = BeanMapper.map(entity, InfoTrackVO.class);
        //vo.setRecords(recordService.getRecord(vo.getBillCode()));
        if(vo != null){
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
            vo.setFollowStateName(BidStateEnum.getNameByCode(vo.getFollowState()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoTrackVO> vos) {
        service.removeByIds(vos.stream().map(InfoTrackVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("followUnitName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<InfoTrackEntity> page = service.queryPage(param,false);
        IPage<InfoTrackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoTrackVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("followUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<InfoTrackEntity> list = service.queryList(param);

        List<InfoTrackVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, InfoTrackVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setFollowStateName(BidStateEnum.getNameByCode(vo.getFollowState()));
            });
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("InfoTrack-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refInfoTrackData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> refInfoTrackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("unitDirectorName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 查询未中止 */
        param.getParams().put("isStop", new Parameter(QueryParam.EQ , BidCommonConsts.NO));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 跟踪中 **/
        //param.getParams().put("followState", new Parameter(QueryParam.EQ , BidStateEnum.GEN_ZONG_ZHONG.getCode()));
        /** 已通过 **/
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InfoTrackEntity> page = service.queryPage(param,false);
        IPage<InfoTrackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoTrackVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @Autowired
    private ISummaryService summaryService;

    /**
     * @param
     * @Description getBidSurvey 投标统计
     */
    @RequestMapping(value = "/getBidSurvey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey() {
        List<ResultVO> resultVOS = new ArrayList<>();
        QueryParam param = new QueryParam();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        LocalDateTime yearStart = now.with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
        LocalDateTime yearEnd = now.with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);

        param.getParams().put("createTime", new Parameter(QueryParam.BETWEEN,yearStart.format(fmt)+","+yearEnd.format(fmt) ));

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        IPage<InfoTrackEntity> infoTrackEntityIPage = service.queryPage(param, false);
        IPage<SummaryEntity> summaryEntityIPage = summaryService.queryPage(param, false);
        ResultVO resultVO1 = new ResultVO();
        resultVO1.setName("本年新增数（变动）");
        resultVO1.setValue((int)infoTrackEntityIPage.getTotal());
        resultVOS.add(resultVO1);
        ResultVO resultVO2 = new ResultVO();
        resultVO2.setName("本年结束数（变动）");
        resultVO2.setValue((int)summaryEntityIPage.getTotal());
        resultVOS.add(resultVO2);
        return CommonResponse.success(resultVOS);
    }


}
