package com.ejianc.business.steelstructure.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.consts.SpecialityIdEnum;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.steelstructure.income.bean.TaskEntity;
import com.ejianc.business.steelstructure.income.service.ITaskService;
import com.ejianc.business.steelstructure.income.vo.TaskVO;

/**
 * 承揽任务
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("task")
public class TaskController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ITaskService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TaskVO> saveOrUpdate(@RequestBody TaskVO saveOrUpdateVO) {
    	TaskEntity entity = BeanMapper.map(saveOrUpdateVO, TaskEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam=BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String>billCode=billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }else{
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	TaskVO vo = BeanMapper.map(entity, TaskVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaskVO> queryDetail(Long id) {
    	TaskEntity entity = service.selectById(id);
    	TaskVO vo = BeanMapper.map(entity, TaskVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TaskVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TaskVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
           /* if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
            }*/
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<TaskEntity> page = service.queryPage(param,false);
        IPage<TaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaskVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TaskEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Task-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTaskData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> refTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TaskEntity> page = service.queryPage(param,false);
        IPage<TaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaskVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 获取合同总金额（组织本下）
     * year == 0时，取所有年份的
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getContractValueByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value = "orgId", required = true) Long orgId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            //项目部
            departmentIds.add(org.getId());
        });

        /** makeOrgId */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, departmentIds));

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        /** ywDate    参数year为0时，取所有的*/

        param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear()+ "-12-31"));


        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(10000);

        List<TaskEntity> undertakeEntities = service.queryList(param);
        logger.info("-----------获取承揽任务数据共{}条。",undertakeEntities.size());
        logger.info("-----------获取承揽任务数据:{}。",undertakeEntities.size());
        for (TaskEntity entity:undertakeEntities){
            bigDecimal = bigDecimal.add(entity.getProjectCost());
        }
        return CommonResponse.success("查询合同总金额成功！",bigDecimal.multiply(bigDecimal1));
    }


    /**
     * 获取饼状图信息（组织本下）
     * @param orgId
     * @param time 1：月度  2：季度  3：年度
     *             type 0数量纬度（不显示补充协议） 1金额维度（显示补充协议）
     * @return
     */
    @RequestMapping(value = "/getUndertakeInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> getUndertakeInfo(@RequestParam(value = "orgId", required = true) Long orgId,
                                                                 Integer time,
                                                                 Integer dateIn
                                                                 //, @RequestParam(value = "type", required = true) Integer type
    ) {


        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(3 == org.getOrgType()  ||  2 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
        });

        /** makeOrgId */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, departmentIds));

        /** ywDate */
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();

        if (time != null) {
            if (time.equals(1)){//月度
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getMonthStartTime(dateTimeFormatter) +","+ getMonthEndTime(dateTimeFormatter)));
            }else if (time.equals(2)){//季度
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getFromThisQuarterStartTime(nowDate,dateTimeFormatter) +","+ getFromThisQuarterEndTime(nowDate,dateTimeFormatter)));
            }else {
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getFromThisYearStartTime(nowDate,dateTimeFormatter) +","+ getFromThisYearEndTime(nowDate,dateTimeFormatter)));
            }
        }else if(dateIn != null){
            param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                    dateIn+"-01-01,"+dateIn+"-12-31" ));
        }

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        /**
         * 当取值为数量时，只显示主合同
         */
//        if(type != null && type == 0){
//            param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));
//        }

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        wrapper.groupBy("speciality_id");

        List<UndertakeApiVO> undertakeVOS = service.queryUndertakeInfoList(wrapper);
        //param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper(param);

        wrapper1.groupBy("speciality_id");
        List<UndertakeApiVO> undertakeVOS1 = service.queryUndertakeInfoList(wrapper1);

        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<>();

        UndertakeApiVO vo1 = new UndertakeApiVO(SpecialityIdEnum.CODE_1.getCode(),SpecialityIdEnum.CODE_1.getName(),new BigDecimal(0.00),0);//房屋建筑

        UndertakeApiVO vo2 = new UndertakeApiVO(SpecialityIdEnum.CODE_2.getCode(),SpecialityIdEnum.CODE_2.getName(),new BigDecimal(0.00),0);//市政工程

        UndertakeApiVO vo3 = new UndertakeApiVO(SpecialityIdEnum.CODE_3.getCode(),SpecialityIdEnum.CODE_3.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo4 = new UndertakeApiVO(SpecialityIdEnum.CODE_4.getCode(),SpecialityIdEnum.CODE_4.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo5 = new UndertakeApiVO(SpecialityIdEnum.CODE_5.getCode(),SpecialityIdEnum.CODE_5.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo6 = new UndertakeApiVO(SpecialityIdEnum.CODE_6.getCode(),SpecialityIdEnum.CODE_6.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo7 = new UndertakeApiVO(SpecialityIdEnum.CODE_7.getCode(),SpecialityIdEnum.CODE_7.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo8 = new UndertakeApiVO(SpecialityIdEnum.CODE_8.getCode(),SpecialityIdEnum.CODE_8.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo9 = new UndertakeApiVO(SpecialityIdEnum.CODE_9.getCode(),SpecialityIdEnum.CODE_9.getName(),new BigDecimal(0.00),0);//


        for (UndertakeApiVO vo : undertakeVOS){
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())){
                //vo3.setSum(vo.getSum());
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())){
                //vo4.setSum(vo.getSum());
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())){
                // vo5.setSum(vo.getSum());
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())){
                // vo6.setSum(vo.getSum());
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())){
                //vo7.setSum(vo.getSum());
                vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())){
                //vo8.setSum(vo.getSum());
                vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())){
                //vo9.setSum(vo.getSum());
                vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())){
                //vo1.setSum(vo1.getSum()+vo.getSum());//总数
                vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())){
                //vo2.setSum(vo2.getSum()+vo.getSum());//总数
                vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }
        }

        for (UndertakeApiVO vo : undertakeVOS1){
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())){
                vo3.setSum(vo.getSum());
                //vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())){
                vo4.setSum(vo.getSum());
                //vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())){
                vo5.setSum(vo.getSum());
                //vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())){
                vo6.setSum(vo.getSum());
                //vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())){
                vo7.setSum(vo.getSum());
                //vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())){
                vo8.setSum(vo.getSum());
                //vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())){
                vo9.setSum(vo.getSum());
                //vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())){
                vo1.setSum(vo1.getSum()+vo.getSum());//总数
                //vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())){
                vo2.setSum(vo2.getSum()+vo.getSum());//总数
                //vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }
        }

        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        undertakeApiVOS.add(vo8);
        undertakeApiVOS.add(vo9);

        return CommonResponse.success("查询成功！",undertakeApiVOS);
    }




    /**
     * 本月开始时间
     * @param dateTimeFormatter
     * @return
     */
    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    /**
     * 本月结束时间
     *
     * @return
     */
    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }


    //获取本季度开始时间
    public static String getFromThisQuarterStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);

    }
    //获取本季度结束时间
    public static String getFromThisQuarterEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    /**
     * 今年起开始时间
     *
     * @return
     */
    public static String getFromThisYearStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    /**
     * 今年起结束时间
     *
     * @return
     */
    public static String getFromThisYearEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }


}
