package com.ejianc.business.steelstructure.income.controller.api;

import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/api/projectCostManagementApi")
public class ProjectCostManagementApi {

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IContractRegisterService contractService;

    //6）预算金额与施工合同金额对比
    @GetMapping("/queryBudgetDivideIncome")
    public CommonResponse<BigDecimal> queryBudgetDivideIncome(@RequestParam(value = "orgId")  Long orgId) {

        //获取项目预算书总金额
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        param.getParams().put("incomeFlag", new Parameter(QueryParam.EQ, 1));
        List<BudgetEntity> budgetEntities = budgetService.queryList(param);
        BigDecimal sumBudgetMny = new BigDecimal(0);
         sumBudgetMny = budgetEntities.stream().map(BudgetEntity::getBudgetTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

         //获取施工合同金额
        QueryParam param1 = new QueryParam();
        param1.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param1.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param1.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        List<ContractRegisterEntity> contractRegisterEntities = contractService.queryList(param1);
        BigDecimal incomeMny = new BigDecimal(0);
        if (contractRegisterEntities != null && contractRegisterEntities.size()>0){
           // incomeMny = contractRegisterEntities.get(0).getTotalAfterCostAdjustTaxMny();//工程造价调整后总金额
            incomeMny = contractRegisterEntities.get(0).getNicContractMny();//工程造价调整后总金额(不含暂列金额)
        }
        if (sumBudgetMny.compareTo(BigDecimal.ZERO)==0 || incomeMny.compareTo(BigDecimal.ZERO)==0 ){
            return CommonResponse.success("查询成功！",BigDecimal.ZERO);
        }else {
            return CommonResponse.success("查询成功！",sumBudgetMny.divide(incomeMny,4,BigDecimal.ROUND_DOWN));
        }

    }

}
