package com.ejianc.business.steelstructure.income.mapper;

import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.steelstructure.income.vo.CustomerCountWithYearVO;
import com.ejianc.business.steelstructure.warn.SqlParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractRegisterMapper extends BaseCrudMapper<ContractRegisterEntity> {

    List<Map<String,Object>> queryBudgetWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryCostWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryContractRegisterWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<ContractRegisterVO> querySettleReportWarnContract(@Param("tenantId") Long tenantId);

    List<ContractRegisterVO> queryFinalizedWarnContract(@Param("tenantId") Long tenantId);

//    List<Map<String,Object>> queryBudgetInWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);
    CustomerIncomeInfoVO queryCustomerInfo(@Param("customerId") Long customerId);

    List<CustomerCountWithYearVO> queryCountByCustomerId(@Param("customerId") List<Long> customerId);

    //根据项目id更改计划开工日期、计划竣工日期、工期
    @Update("UPDATE `ejc-promarket`.ejc_promarket_project_set " +
            "SET plan_start_date = #{planStartDate}," +
            "plan_end_date = #{planEndDate}," +
            "plan_date_num = #{planDateNum} " +
            "WHERE id = #{projectId}")
    Boolean updatePlanDate(@Param("projectId") Long projectId,
                        @Param("planStartDate") Date planStartDate,
                        @Param("planEndDate") Date planEndDate,
                        @Param("planDateNum") Integer planDateNum);
}
