package com.ejianc.business.steelstructure.income.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.vo.*;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 项目预算书
 *
 * @author generator
 *
 */
public interface IBudgetService extends IBaseService<BudgetEntity> {

    BudgetVO saveOrUpdate(BudgetVO saveorUpdateVO);

    BudgetVO queryDetail(Long id);

    BudgetVO saveBudget(BudgetVO saveorUpdateVO);

    void delete(List<BudgetVO> vos);

    CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response);

    CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response);

    BudgetVO queryBudgetDetail(Long id);

    void updateUseId(Long useId,String useType,List<Long> budgetIds);

    List<BudgetVO> selectByUseId(Long useId);

    void deleteUseId(List<Long> useId);

    BudgetHistoryVO queryBudgetHistory(Long id,Long accountingId);

    void relevanceBudget(Long useId, List<Long> ids, String useType);

    void deleteRelevanceBudget(List<Long> ids);

    CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response);

    List<BudgetReportVO> querySumBudgetMnyNew(Long projectId, String beginPeriod,String endDate);

    List<BudgetReportVO> querySumBudgetMny(Long projectId, String beginPeriod,String endDate);

    JSONObject pageRevenueMaterials(QueryParam queryParam);

    IPage<BudgetDetailReportVO> getBudgetReport(QueryParam param, Boolean isExport);

    List<SubjectReportVO> getCostAllDetails(QueryParam param);

    List<RevenueMaterialsVO> getMaterialSummarylist(QueryParam param);
}
