package com.ejianc.business.steelstructure.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.vo.*;
import com.ejianc.business.steelstructure.warn.SqlParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
public interface IContractRegisterService extends IBaseService<ContractRegisterEntity> {

    ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO);

    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    List<ContractRegisterVO> excelExport(QueryParam param);

    ContractRegisterVO addRegisterByRevId(Long reviewId);
    
    ContractRegisterVO addSupplementByConId(Long mainContractId);
    
    RegisterSupplementHistoryVO querySupplementRecord(Long id);

    List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId);

    boolean pushContract(ContractRegisterVO map,Boolean updateLevel);

    boolean delContractFromPool(Long billId);

    List<Map<String,Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryCostWarnContract(List<SqlParam> sqlParamList);

    ContractReviewVO queryReviewByProject(Long projectId);

    List<Map<String,Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList);

     CommonResponse<ContractRegisterVO> pushToCw(ContractRegisterEntity contractEntity);

    CustomerIncomeInfoVO queryCustomerInfo(Long customerId);
    List<CustomerCountWithYearVO> queryCountByCustomerId(Long customerId,String dateIn);
}
