package com.ejianc.business.steelstructure.income.service;

import com.ejianc.business.steelstructure.income.bean.FinalizedEntity;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.steelstructure.income.vo.FinalizedHistoryVO;
import com.ejianc.business.steelstructure.income.vo.FinalizedVO;
import com.ejianc.business.steelstructure.income.vo.SettleReportVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 工程定案
 * 
 * @author generator
 * 
 */
public interface IFinalizedService extends IBaseService<FinalizedEntity> {


    FinalizedVO saveOrUpdate(FinalizedVO saveOrUpdateVO);
    
    SettleReportVO querySettleReport(Long projectId, Long contractId);

    FinalizedVO queryFinalizedList(Long projectId, Long contractId, Long id);

    Boolean validateFinalStage(Long projectId, Long contractId, String finalStage, Long id);

    FinalizedHistoryVO queryFinalizedRecord(Long id);

    boolean pushSettleToPool(FinalizedVO vo);

    boolean delSettleFromPool(Long id);

    boolean pushContract(ContractRegisterVO vo, String performanceStatus);

    /**
     * 发送消息提醒
     */
    boolean sendMsg(List<FinalizedVO> vos);
}
