package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.steelstructure.income.bean.BudgetOtherEntity;
import com.ejianc.business.steelstructure.income.mapper.BudgetOtherMapper;
import com.ejianc.business.steelstructure.income.service.IBudgetOtherService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 其他项清单
 * 
 * @author generator
 * 
 */
@Service("budgetOtherService")
public class BudgetOtherServiceImpl extends BaseServiceImpl<BudgetOtherMapper, BudgetOtherEntity> implements IBudgetOtherService{

    @Override
    public void delOtherByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetOtherEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delOtherBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetOtherEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetOtherEntity> queryOtherByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetOtherEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
