package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.steelstructure.income.bean.BudgetSubEntity;
import com.ejianc.business.steelstructure.income.mapper.BudgetSubMapper;
import com.ejianc.business.steelstructure.income.service.IBudgetSubService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分部分项清单
 * 
 * @author generator
 * 
 */
@Service("budgetSubService")
public class BudgetSubServiceImpl extends BaseServiceImpl<BudgetSubMapper, BudgetSubEntity> implements IBudgetSubService{

    @Override
    public void delSubByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetSubEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delSubBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetSubEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetSubEntity> querySubByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetSubEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
