package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.income.bean.ClaimEntity;
import com.ejianc.business.steelstructure.income.bean.ClaimRecordsEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.cons.CommonConstants;
import com.ejianc.business.steelstructure.income.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.income.service.IClaimRecordsService;
import com.ejianc.business.steelstructure.income.service.IClaimService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.utils.MathUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

@Service("claim") 
public class ClaimBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IClaimService claimService;
	
	@Autowired
	private IContractRegisterService contractRegisterService;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IClaimRecordsService claimRecordsService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ClaimEntity claimEntity = claimService.selectById(billId);


		/**
		 * 甲方批复单据审批通过后逻辑不改变
		 */

		if (claimEntity.getIsReplayBill() == 1){
			ClaimEntity claimEntityZhu = claimService.selectById(claimEntity.getReplayBillId());
			if (claimEntityZhu!=null){
				LambdaUpdateWrapper<ClaimEntity> wrapper1 = new LambdaUpdateWrapper();
				wrapper1.eq(ClaimEntity::getId,claimEntity.getReplayBillId());
				wrapper1.set(ClaimEntity::getReplyDate,claimEntity.getReplyDate());
				wrapper1.set(ClaimEntity::getReplyStatus,claimEntity.getReplyStatus());
				wrapper1.set(ClaimEntity::getReplyMny,claimEntity.getReplyMny());
				wrapper1.set(ClaimEntity::getReplyTaxMny,claimEntity.getReplyTaxMny());
				wrapper1.set(ClaimEntity::getReplyTax,claimEntity.getReplyTax());
				wrapper1.set(ClaimEntity::getReplyDuration,claimEntity.getReplyDuration());

				ContractRegisterEntity contractRegisterEntity1 = contractRegisterService.selectById(claimEntityZhu.getContractId());
				if (BillPushStatusEnum.推送成功.getStatus().equals(contractRegisterEntity1.getBillPushFlag())){
					//签章洽商索赔更新合同池
					claimEntityZhu.setReplyTaxMny(claimEntity.getReplyTaxMny());
					claimEntityZhu.setReplyMny(claimEntity.getReplyMny());
					claimEntityZhu.setReplyTax(claimEntity.getReplyTax());
					claimEntityZhu.setReplyStatus(claimEntity.getReplyStatus());
					boolean pushResult = claimService.updateContract(claimEntityZhu,true);
					if(pushResult) {
						wrapper1.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.推送成功.getStatus());
					} else {
						wrapper1.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.未成功推送.getStatus());
					}
				}

				claimService.update(wrapper1);

				LambdaUpdateWrapper<ClaimRecordsEntity> updateWrapperRecords = new LambdaUpdateWrapper<>();
				updateWrapperRecords.eq(ClaimRecordsEntity::getClaimId,claimEntityZhu.getId());
				updateWrapperRecords.set(ClaimRecordsEntity::getReplyStatus,claimEntityZhu.getReplyStatus());
				claimRecordsService.update(updateWrapperRecords);

			}else{
				return CommonResponse.error("单据不存在！");
			}
		}else {

			ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(claimEntity.getContractId());
			LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
			if ("QS".equals(claimEntity.getBillType())){
				BigDecimal sumNegotiateMny = MathUtil.safeAdd(contractRegisterEntity.getSumNegotiateMny(),claimEntity.getClaimMny());
				BigDecimal sumNegotiateTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumNegotiateTaxMny(),claimEntity.getClaimTaxMny());
				wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
				wrapper.set(ContractRegisterEntity::getSumNegotiateMny,sumNegotiateMny);
				wrapper.set(ContractRegisterEntity::getSumNegotiateTaxMny,sumNegotiateTaxMny);
			}else if("QZ".equals(claimEntity.getBillType())){
				BigDecimal sumVisaMny = MathUtil.safeAdd(contractRegisterEntity.getSumVisaMny(),claimEntity.getClaimMny());
				BigDecimal sumVisaTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumVisaTaxMny(),claimEntity.getClaimTaxMny());
				wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
				wrapper.set(ContractRegisterEntity::getSumVisaMny,sumVisaMny);
				wrapper.set(ContractRegisterEntity::getSumVisaTaxMny,sumVisaTaxMny);
			}else if("SP".equals(claimEntity.getBillType())){
				BigDecimal sumClaimMny = MathUtil.safeAdd(contractRegisterEntity.getSumClaimMny(),claimEntity.getClaimMny());
				BigDecimal sumClaimTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumClaimTaxMny(),claimEntity.getClaimTaxMny());
				wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
				wrapper.set(ContractRegisterEntity::getSumClaimMny,sumClaimMny);
				wrapper.set(ContractRegisterEntity::getSumClaimTaxMny,sumClaimTaxMny);
			}
			contractRegisterService.update(wrapper);

			LambdaUpdateWrapper<ContractRegisterEntity> lambda = new LambdaUpdateWrapper<>();
			BigDecimal sumOperateMny = MathUtil.safeAdd(contractRegisterEntity.getSumOperateMny(),claimEntity.getClaimMny());
			BigDecimal sumOperateTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumOperateTaxMny(),claimEntity.getClaimTaxMny());
			lambda.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
			lambda.set(ContractRegisterEntity::getSumOperateMny,sumOperateMny);
			lambda.set(ContractRegisterEntity::getSumOperateTaxMny,sumOperateTaxMny);
			contractRegisterService.update(lambda);

			// 回写提交日期
			LambdaUpdateWrapper<ClaimEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(ClaimEntity::getCommitDate, new Date());
			updateWrapper.eq(ClaimEntity::getId, claimEntity.getId());

			if (BillPushStatusEnum.推送成功.getStatus().equals(contractRegisterEntity.getBillPushFlag())){
				contractRegisterEntity.setSumOperateTaxMny(sumOperateTaxMny);
				contractRegisterEntity.setSumOperateMny(sumOperateMny);
				//签章洽商索赔更新合同池
				boolean pushResult = claimService.updateContract(claimEntity,true);
				if(pushResult) {
					updateWrapper.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.推送成功.getStatus());
				} else {
					updateWrapper.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.未成功推送.getStatus());
				}
			}

			// 回写变更签证索赔记录引用状态
			LambdaUpdateWrapper<ClaimRecordsEntity> claimRecordsWrapper = new LambdaUpdateWrapper<>();
			claimRecordsWrapper.eq(ClaimRecordsEntity::getClaimId, claimEntity.getId());
			claimRecordsWrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.YSL);
			claimRecordsService.update(claimRecordsWrapper);

			claimService.update(updateWrapper);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(res.isSuccess()) {
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ClaimEntity claimEntity = claimService.selectById(billId);
		ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(claimEntity.getContractId());
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		if ("QS".equals(claimEntity.getBillType())){
			BigDecimal sumNegotiateMny = MathUtil.safeSub(contractRegisterEntity.getSumNegotiateMny(),claimEntity.getClaimMny());
			BigDecimal sumNegotiateTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumNegotiateTaxMny(),claimEntity.getClaimTaxMny());
			wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
			wrapper.set(ContractRegisterEntity::getSumNegotiateMny,sumNegotiateMny);
			wrapper.set(ContractRegisterEntity::getSumNegotiateTaxMny,sumNegotiateTaxMny);
		}else if("QZ".equals(claimEntity.getBillType())){
			BigDecimal sumVisaMny = MathUtil.safeSub(contractRegisterEntity.getSumVisaMny(),claimEntity.getClaimMny());
			BigDecimal sumVisaTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumVisaTaxMny(),claimEntity.getClaimTaxMny());
			wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
			wrapper.set(ContractRegisterEntity::getSumVisaMny,sumVisaMny);
			wrapper.set(ContractRegisterEntity::getSumVisaTaxMny,sumVisaTaxMny);
		}else if("SP".equals(claimEntity.getBillType())){
			BigDecimal sumClaimMny = MathUtil.safeSub(contractRegisterEntity.getSumClaimMny(),claimEntity.getClaimMny());
			BigDecimal sumClaimTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumClaimTaxMny(),claimEntity.getClaimTaxMny());
			wrapper.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
			wrapper.set(ContractRegisterEntity::getSumClaimMny,sumClaimMny);
			wrapper.set(ContractRegisterEntity::getSumClaimTaxMny,sumClaimTaxMny);
		}
		contractRegisterService.update(wrapper);

		LambdaUpdateWrapper<ContractRegisterEntity> lambda = new LambdaUpdateWrapper<>();
		BigDecimal sumOperateMny = MathUtil.safeSub(contractRegisterEntity.getSumOperateMny(),claimEntity.getClaimMny());
		BigDecimal sumOperateTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumOperateTaxMny(),claimEntity.getClaimTaxMny());
		lambda.eq(ContractRegisterEntity::getId,claimEntity.getContractId());
		lambda.set(ContractRegisterEntity::getSumOperateMny,sumOperateMny);
		lambda.set(ContractRegisterEntity::getSumOperateTaxMny,sumOperateTaxMny);
		contractRegisterService.update(lambda);

		if (BillPushStatusEnum.推送成功.getStatus().equals(contractRegisterEntity.getBillPushFlag())){
			//签章洽商索赔更新合同池
			boolean pushResult = claimService.updateContract(claimEntity,false);
			if(pushResult) {
				claimEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
				claimService.saveOrUpdate(claimEntity);
			}
		}

		return CommonResponse.success();
	}

}
