package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterHistoryEntity;
import com.ejianc.business.steelstructure.income.mapper.ContractRegisterHistoryMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterHistoryService;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 合同登记历史记录
 * 
 * @author generator
 * 
 */
@Service("contractRegisterHistoryService")
public class ContractRegisterHistoryServiceImpl extends BaseServiceImpl<ContractRegisterHistoryMapper, ContractRegisterHistoryEntity> implements IContractRegisterHistoryService{

    @Override
    public ContractRegisterHistoryVO queryDetailByChangeId(Long id) {
        LambdaQueryWrapper<ContractRegisterHistoryEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterHistoryEntity::getChangeId, id);
        ContractRegisterHistoryEntity entity = this.getOne(wrapper);
        
        return BeanMapper.map(entity, ContractRegisterHistoryVO.class);
    }
}
