package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractSuspendEntity;
import com.ejianc.business.steelstructure.income.enums.ContractStatusEnum;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractSuspendService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("contractSuspend") 
public class ContractSuspendBpmServiceImpl implements ICommonBusinessService {
	
	
	@Autowired
	private IContractSuspendService service;

	@Autowired
	private IContractRegisterService registerService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractSuspendEntity entity = service.selectById(billId);
		
		if (Objects.equals(entity.getSuspendType(), "0")) {
			// 回写合同中止状态
			LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.已冻结.getCode());
			wrapper.set(ContractRegisterEntity::getIsSuspend, 1);
			wrapper.eq(ContractRegisterEntity::getId, entity.getContractId());
			registerService.update(wrapper);
		}else {
			// 回写合同中止状态
			LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
			wrapper.set(ContractRegisterEntity::getIsSuspend, 0);
			wrapper.eq(ContractRegisterEntity::getId, entity.getContractId());
			registerService.update(wrapper);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractSuspendEntity entity = service.selectById(billId);
		
		LambdaQueryWrapper<ContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(ContractSuspendEntity::getContractId, entity.getContractId());
		wrapper.orderByDesc(ContractSuspendEntity::getCreateTime);
		List<ContractSuspendEntity> list = service.list(wrapper);

		if (ListUtil.isNotEmpty(list)) {
			long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
			if (count > 0) {
				throw new BusinessException("当前合同存在非审批通过态的合同中止/中止解除，无法撤回！");
			}

			ContractSuspendEntity suspendEntity = list.get(0);
			if (!Objects.equals(entity.getId(), suspendEntity.getId())) {
				throw new BusinessException("存在比当前创建时间更晚的工程造价调整申请，无法撤回!");
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractSuspendEntity entity = service.selectById(billId);

		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		if (Objects.equals(entity.getSuspendType(), "0")) {
			wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
			wrapper.set(ContractRegisterEntity::getIsSuspend, 0);
		}else {
			wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.已冻结.getCode());
			wrapper.set(ContractRegisterEntity::getIsSuspend, 1);
		}

		wrapper.eq(ContractRegisterEntity::getId, entity.getContractId());
		registerService.update(wrapper);
		
		return CommonResponse.success();
	}

}
