package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractSuspendEntity;
import com.ejianc.business.steelstructure.income.mapper.ContractSuspendMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractSuspendService;
import com.ejianc.business.steelstructure.income.utils.BillTypeCodeEnum;
import com.ejianc.business.steelstructure.income.utils.ValidateUtil;
import com.ejianc.business.steelstructure.income.vo.ContractSuspendVO;
import com.ejianc.business.steelstructure.income.vo.RegisterSuspendHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 合同中止/中止解除
 * 
 * @author generator
 * 
 */
@Service("contractSuspendService")
public class ContractSuspendServiceImpl extends BaseServiceImpl<ContractSuspendMapper, ContractSuspendEntity> implements IContractSuspendService{

    private static final String INCOME_SUSPEND_RELIEVE = "INCOME_SUSPEND_RELIEVE";//此处需要根据实际修改
    
    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ValidateUtil validateUtil;
    
    @Override
    public ContractSuspendVO saveOrUpdate(ContractSuspendVO saveOrUpdateVO) {
        // 保存时校验合同version是否一致
        if (!Objects.equals(null, saveOrUpdateVO.getContractId())) {
            if(!validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()),
                    BillTypeCodeEnum.施工合同.getCode(), saveOrUpdateVO.getContractVersion())){
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }
        
        ContractSuspendEntity entity = BeanMapper.map(saveOrUpdateVO, ContractSuspendEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            validateContract(entity.getContractId(), entity.getId());
            
            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_SUSPEND_RELIEVE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            // 修改
            validateContract(entity.getContractId(), entity.getId());
            
        }
        this.saveOrUpdate(entity, false);
        ContractSuspendVO vo = BeanMapper.map(entity, ContractSuspendVO.class);
        
        return vo;
    }

    @Override
    public ContractSuspendVO queryLastSuspend(Long contractId) {
        List<ContractSuspendEntity> list = querySuspendByContractId(contractId);
        if (ListUtil.isEmpty(list)) {
            return new ContractSuspendVO();
        }
        
        return BeanMapper.map(list.get(0), ContractSuspendVO.class);
    }

    @Override
    public RegisterSuspendHistoryVO querySuspendRecord(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);

        RegisterSuspendHistoryVO vo = new RegisterSuspendHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        vo.setContractStartDate(entity.getStartDate());
        vo.setContractEndDate(entity.getEndDate());
        
        LambdaQueryWrapper<ContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractSuspendEntity::getContractId, id);
        wrapper.orderByDesc(ContractSuspendEntity::getSuspendRelieveDate);
        List<ContractSuspendEntity> list = super.list(wrapper);
        vo.setDetailList(BeanMapper.mapList(list, ContractSuspendVO.class));

        return vo;
    }

    @Override
    public List<ContractSuspendEntity> querySuspendByContractId(Long contractId) {
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        
        LambdaQueryWrapper<ContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractSuspendEntity::getContractId, contractId);
        wrapper.in(ContractSuspendEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);

        List<ContractSuspendEntity> list = this.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }
        
        return list;
    }

    @Override
    public Boolean validateContract(Long contractId, Long id) {
        //同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<ContractSuspendEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过的合同中止/中止解除，不允许新增!");
        }
        return true;
    }

}
