package com.ejianc.business.steelstructure.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.CostAdjustEntity;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.ICostAdjustService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;

@Service("costAdjust") 
public class CostAdjustBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICostAdjustService service;

	@Autowired
	private IContractRegisterService registerService;

	@Autowired
	private IPMContractApi contractApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		logger.info("回写合同合同工程造价及变动合计总金额开始");

		// 回写合同工程造价及变动合计总金额
		CostAdjustEntity entity = service.selectById(billId);
		// 查询合同
		ContractRegisterEntity registerEntity = registerService.selectById(entity.getContractId());

		BigDecimal totalCostAdjustTaxMny = ComputeUtil.safeAdd(registerEntity.getTotalCostAdjustTaxMny(), entity.getApplyChangeTaxMny()); // 工程造价调整金额合计
		BigDecimal totalCostAdjustMny = ComputeUtil.safeAdd(registerEntity.getTotalCostAdjustMny(), entity.getApplyChangeMny()); // 工程造价调整金额合计(无税)
		BigDecimal applyChangeTax = ComputeUtil.safeSub(entity.getApplyChangeTaxMny(), entity.getApplyChangeMny());
		BigDecimal totalCostAdjustTax = ComputeUtil.safeAdd(registerEntity.getTotalCostAdjustTax(), applyChangeTax); // 工程造价调整税额

		// 更新合同金额信息
		registerEntity.setCostChangeTotalTaxMny(entity.getCostChangeTotalTaxMny());
		registerEntity.setCostChangeTotalMny(entity.getCostChangeTotalMny());
		registerEntity.setTotalCostAdjustTaxMny(totalCostAdjustTaxMny);
		registerEntity.setTotalCostAdjustMny(totalCostAdjustMny);
		registerEntity.setTotalCostAdjustTax(totalCostAdjustTax);
		registerEntity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(registerEntity.getBaseTaxMoney(), totalCostAdjustTaxMny)); // 工程造价调整后总金额
		registerEntity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(registerEntity.getBaseMoney(), totalCostAdjustMny)); // 工程造价调整后总金额(无税)
		registerEntity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(registerEntity.getBaseTax(), totalCostAdjustTax)); // 工程造价调整后税额
		registerEntity.setNicContractMny(ComputeUtil.safeAdd(registerEntity.getNotIncludeProvisionalMny(), totalCostAdjustTaxMny)); // 工程造价调整后总金额(不含暂列金额)
		registerService.saveOrUpdate(registerEntity);

		logger.info("回写合同合同工程造价及变动合计总金额结束");

		// 更新合同池金额信息
		service.updateContractPool(registerEntity);



		/**
		 * 推送财务中间表  ------------------------开始
		 * 工程造价调整
		 */
		logger.info("推送财务中间表  ------------------------开始");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");


		PMContractVO pmContractVO = BeanMapper.map(entity, PMContractVO.class);

			pmContractVO.setZgbz(0);//是否是暂估合同  否
			pmContractVO.setBslx("工程造价调整");

		pmContractVO.setContractId(String.valueOf(billId));//合同id

		pmContractVO.setZhuContractId(String.valueOf(entity.getContractId()));//主合同id

		if (entity.getApplyAdjustDate() != null) {
			pmContractVO.setDjrq(sdf.format(entity.getApplyAdjustDate()));//单据日期  ——>  申请调整日期
		}
		pmContractVO.setContractCode(entity.getBillCode());//合同编号

		pmContractVO.setBcbgje(entity.getApplyChangeTaxMny());//本次变动金额 取 申请变动金额

		pmContractVO.setGczjtzhje(entity.getCostChangeTotalTaxMny()); //工程造价调整后金额（含税）  取   工程造价及变动合计总金额

		pmContractVO.setContractTypeName("施工合同");//合同类型2



		CommonResponse<PMContractVO> pmContractVOCommonResponse = contractApi.saveContract(pmContractVO);



		logger.info("推送财务中间表  ------------------------结束"+ JSON.toJSONString(pmContractVOCommonResponse));
		/**
		 * 推送财务中间表  ------------------------结束
		 */

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		CostAdjustEntity entity = service.selectById(billId);


		//检查是否被财务引用，如果引用则不允许退回，若无引用，删除财务数据
		CommonResponse<List<PMContractVO>> listCommonResponse = contractApi.queryDetail(String.valueOf(billId), 0);
		if (listCommonResponse.getCode() == 0){
			List<PMContractVO> data = listCommonResponse.getData();
			for (PMContractVO contractVO : data){
				if (contractVO.getYybs() == 1){//被引用
					return CommonResponse.error("已被财务系统使用！");
				}
			}
			CommonResponse<List<String>> updateContract = contractApi.updateContract(String.valueOf(billId), 0);
			if (updateContract.getCode() != 0){
				return CommonResponse.error("修改财务中间表失败！");
			}


		}

		// 查询合同
		ContractRegisterEntity registerEntity = registerService.selectById(entity.getContractId());

		// 查询不含本期累计申请变动金额
		LambdaQueryWrapper<CostAdjustEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(CostAdjustEntity::getContractId, entity.getContractId());
		wrapper.orderByDesc(CostAdjustEntity::getCreateTime);
		List<CostAdjustEntity> list = service.list(wrapper);

		if (ListUtil.isNotEmpty(list)) {
			long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
			if (count > 0) {
				throw new BusinessException("当前合同存在非审批通过态的工程造价调整申请，无法撤回！");
			}
			
			CostAdjustEntity adjustEntity = list.get(0);
			if (Objects.equals(entity.getId(), adjustEntity.getId())) {
				if (list.size() >= 2) {
					// 回写合同工程造价及变动合计总金额
					CostAdjustEntity costAdjustEntity = list.get(1);

					BigDecimal totalCostAdjustTaxMny = ComputeUtil.safeSub(registerEntity.getTotalCostAdjustTaxMny(), adjustEntity.getApplyChangeTaxMny());
					BigDecimal totalCostAdjustMny = ComputeUtil.safeSub(registerEntity.getTotalCostAdjustMny(), adjustEntity.getApplyChangeMny());
					BigDecimal applyChangeTax = ComputeUtil.safeSub(adjustEntity.getApplyChangeTaxMny(), adjustEntity.getApplyChangeMny());
					BigDecimal totalCostAdjustTax = ComputeUtil.safeSub(registerEntity.getTotalCostAdjustTaxMny(), applyChangeTax);

					registerEntity.setCostChangeTotalTaxMny(costAdjustEntity.getCostChangeTotalTaxMny());
					registerEntity.setCostChangeTotalMny(costAdjustEntity.getCostChangeTotalMny());
					registerEntity.setTotalCostAdjustTaxMny(totalCostAdjustTaxMny);
					registerEntity.setTotalCostAdjustMny(totalCostAdjustMny);
					registerEntity.setTotalCostAdjustTax(totalCostAdjustTax);
					registerEntity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(registerEntity.getBaseTaxMoney(), totalCostAdjustTaxMny)); // 工程造价调整后总金额
					registerEntity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(registerEntity.getBaseMoney(), totalCostAdjustMny)); // 工程造价调整后总金额(无税)
					registerEntity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(registerEntity.getBaseTax(), totalCostAdjustTax)); // 工程造价调整后税额
					registerEntity.setNicContractMny(ComputeUtil.safeAdd(registerEntity.getNotIncludeProvisionalMny(), totalCostAdjustTaxMny)); // 工程造价调整后总金额(不含暂列金额)
				}else {
					registerEntity.setCostChangeTotalTaxMny(null);
					registerEntity.setCostChangeTotalMny(null);
					registerEntity.setTotalCostAdjustTaxMny(null);
					registerEntity.setTotalCostAdjustMny(null);
					registerEntity.setTotalCostAdjustTax(null);
					registerEntity.setTotalAfterCostAdjustTaxMny(registerEntity.getBaseTaxMoney()); // 工程造价调整后总金额
					registerEntity.setTotalAfterCostAdjustMny(registerEntity.getBaseMoney()); // 工程造价调整后总金额(无税)
					registerEntity.setTotalAfterCostAdjustTax(registerEntity.getBaseTax()); // 工程造价调整后税额
					registerEntity.setNicContractMny(registerEntity.getNotIncludeProvisionalMny()); // 工程造价调整后总金额(不含暂列金额)
				}

				registerService.saveOrUpdate(registerEntity);

				// 更新合同池金额信息
				service.updateContractPool(registerEntity);
			}else {
				throw new BusinessException("存在比当前创建时间更晚的工程造价调整申请，无法撤回!");
			}
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
