package com.ejianc.business.steelstructure.income.service.impl;

import com.ejianc.business.steelstructure.income.bean.ProductionEntity;
import com.ejianc.business.steelstructure.income.service.IProductionService;
import com.ejianc.business.steelstructure.income.vo.ProductionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("production") 
public class ProductionBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProductionService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 推送结算池
		ProductionEntity entity = service.selectById(billId);
		boolean pool = service.pushSettleToPool(BeanMapper.map(entity, ProductionVO.class));
		if(!pool){
			return CommonResponse.error("推送结算池失败");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ProductionEntity entity = service.selectById(billId);
		//同一个合同只能存在一个自由态或审批中的单据
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
		queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
		List<ProductionEntity> list = service.queryList(queryParam, false);
		if (CollectionUtils.isNotEmpty(list)) {
			throw new BusinessException("当前合同存在非审批通过态的产值报量，不允许弃审!");
		}
		// 非最新产值报量单，不允许弃审
		QueryParam param = new QueryParam();
		param.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
		param.getOrderMap().put("create_time", QueryParam.DESC);
		List<ProductionEntity> settleList = service.queryList(param);
		if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)){
			ProductionEntity data = settleList.get(0);
			if (!data.getId().equals(billId)){
				return CommonResponse.error("非最新产值报量单，不允许弃审！");
			}
		}
		// 结算池撤回
		boolean pool = service.delSettleFromPool(billId);
		if(!pool){
			return CommonResponse.error("弃审推送结算池失败");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
