package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.income.bean.InfoTrackEntity;
import com.ejianc.business.steelstructure.income.bean.SummaryEntity;
import com.ejianc.business.steelstructure.income.consts.BidStateEnum;
import com.ejianc.business.steelstructure.income.service.IInfoTrackService;
import com.ejianc.business.steelstructure.income.service.ISummaryService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("summary")
public class SummaryBpmServiceImpl implements ICommonBusinessService {
    /*@Autowired
    private IRecordService recordService;*/
    @Autowired
    private ISummaryService summaryService;
    /*@Autowired
    private IEnrollService enrollService;*/
    @Autowired
    private IInfoTrackService trackService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //投标总结结束回改信息跟踪的跟踪状态值
        SummaryEntity summaryEntity = summaryService.selectById(billId);
        if (summaryEntity != null) {
            Long enrollId = summaryEntity.getEnrollId();
            LambdaUpdateWrapper<InfoTrackEntity> infoTrackEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
            infoTrackEntityLambdaUpdateWrapper.eq(InfoTrackEntity::getId, enrollId);
            infoTrackEntityLambdaUpdateWrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.YI_JIE_SHU.getCode());
            trackService.update(infoTrackEntityLambdaUpdateWrapper);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
       /* LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
        updateWrapper.eq(RecordEntity::getBillId, billId);
        recordService.remove(updateWrapper);*/
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        //投标总结撤回信息跟踪的跟踪状态值改为跟踪中
        SummaryEntity summaryEntity = summaryService.selectById(billId);
        if (summaryEntity != null) {
            LambdaUpdateWrapper<InfoTrackEntity> infoTrackEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
            infoTrackEntityLambdaUpdateWrapper.eq(InfoTrackEntity::getId, summaryEntity.getEnrollId());
            infoTrackEntityLambdaUpdateWrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.GEN_ZONG_ZHONG.getCode());
            trackService.update(infoTrackEntityLambdaUpdateWrapper);
        }
        return CommonResponse.success();
    }

}
