package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.income.vo.WinningBidVO;
import com.ejianc.business.steelstructure.income.bean.SummaryEntity;
import com.ejianc.business.steelstructure.income.mapper.SummaryMapper;
import com.ejianc.business.steelstructure.income.service.ISummaryService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *   投标总结 
 * 
 * @author generator
 * 
 */
@Service("summaryService")
public class SummaryServiceImpl extends BaseServiceImpl<SummaryMapper, SummaryEntity> implements ISummaryService {
    @Autowired
   private SummaryMapper summaryMapper;

    @Override
    public List<WinningBidVO> queryWinningBidList(QueryWrapper wrapper) {
        return summaryMapper.queryWinningBidList(wrapper);
    }

    @Override
    public WinningBidVO querySumbidNumList(List<Long> orgIds, Long tenantId) {
        return summaryMapper.querySumbidNumList(orgIds,tenantId);
    }

    @Override
    public List<WinningBidVO> queryWinningBidPage(Page<WinningBidVO> page, QueryWrapper wrapper) {
        return baseMapper.queryWinningBidList(page, wrapper);
    }

    @Override
    public void changeUseFlag(Long id, Integer useFlag) {
        LambdaUpdateWrapper<SummaryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SummaryEntity::getId,id);
        updateWrapper.set(SummaryEntity::getUseFlag,useFlag);
        baseMapper.update(null,updateWrapper);
    }
}
