package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.steelstructure.income.mapper.SupplierMapper;
import com.ejianc.business.steelstructure.income.bean.SupplierEntity;
import com.ejianc.business.steelstructure.income.service.ISupplierService;

import java.math.BigDecimal;

/**
 * 客户库
 * 
 * @author generator
 * 
 */
@Service("supplierService")
public class SupplierServiceImpl extends BaseServiceImpl<SupplierMapper, SupplierEntity> implements ISupplierService{

    @Override
    public void updateIncomeMny(CustomerIncomeInfoVO customerIncomeInfoVO) {
        //判断顾客等级  5-10亿为大客户  >10亿为战略客户

        Integer level = 1;
        if (customerIncomeInfoVO.getSum() != null){
            if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(500000000) ) > -1
                    && customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000) ) <1
            ){
                level = 2;
            }else if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000) ) > -1){
                level = 3;
            }
        }
        //更新客户信息
        LambdaUpdateWrapper<SupplierEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(SupplierEntity::getIncomeMny,customerIncomeInfoVO.getSum());
        wrapper.set(SupplierEntity::getIncomeNum,customerIncomeInfoVO.getCount());
        wrapper.set(SupplierEntity::getCustomerLevel,level);
        wrapper.eq(SupplierEntity::getId,customerIncomeInfoVO.getCustomerId());
        baseMapper.update(null,wrapper);
    }
}
