package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.steelstructure.income.mapper.SupplyBankMapper;
import com.ejianc.business.steelstructure.income.bean.SupplyBankEntity;
import com.ejianc.business.steelstructure.income.service.ISupplyBankService;

import java.util.List;

/**
 * 客商库-银行信息
 * 
 * @author generator
 * 
 */
@Service("supplyBankService")
public class SupplyBankServiceImpl extends BaseServiceImpl<SupplyBankMapper, SupplyBankEntity> implements ISupplyBankService{

    @Override
    public List<SupplyBankEntity> selectBankListByPid(Long pid) {
        LambdaQueryWrapper<SupplyBankEntity> wrapper = new LambdaQueryWrapper();
        wrapper.eq(SupplyBankEntity::getPid, pid);
        List<SupplyBankEntity> supplyBankEntities = baseMapper.selectList(wrapper);
        return supplyBankEntities;
    }
}
