package com.ejianc.business.steelstructure.income.utils;

import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

@Component
public class IncomeSortUtil<T> {

    //实现排序
    public List<T> entryListToSort(List<T> list) {
        list.sort((o1, o2) -> {
            Class<?> mainClass = o1.getClass();
            Integer preNum = getValue(o1, "detailIndex");
            Integer sufNum = getValue(o2, "detailIndex");
            if (preNum > sufNum) {
                return 1;
            } else if (preNum < sufNum) {
                return -1;
            }
            return 0;
        });
        return list;
    }

    private Integer getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                String value = (String) m.invoke(t, (Object[]) null);
                if(value == null){
                    return 0;
                } else {
                    return Integer.parseInt(value);
                }
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }
}
