package com.ejianc.business.steelstructure.income.utils;

import java.math.BigDecimal;

public class MathUtil {

    public static int precision = 18;

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2){
        if(decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0){
            return new BigDecimal(0);
        }else{
           return decimal1.divide(decimal2, precision ,BigDecimal.ROUND_HALF_EVEN);
        }
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2){
        if(decimal1 == null ){
            return decimal2;
        }
        if(decimal2 == null ){
            return decimal1;
        }
        return decimal1.add(decimal2);
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2){
        if(decimal1 == null ){
            decimal1= new BigDecimal(0);
        }
        if(decimal2 == null ){
            decimal2= new BigDecimal(0);
        }
        return decimal1.multiply(decimal2).setScale(precision, BigDecimal.ROUND_HALF_EVEN);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2){
        if(decimal1 == null ){
            decimal1= new BigDecimal(0);
        }
        if(decimal2 == null ){
            decimal2= new BigDecimal(0);
        }
        return decimal1.subtract(decimal2);
    }

    /**
     * 比较大小,null默认为0
     *
     * @param decimal1
     * @param decimal2
     * @return
     */
    public static int safeCompareTo(BigDecimal decimal1, BigDecimal decimal2) {
        if(decimal1 == null ){
            decimal1= new BigDecimal(0);
        }
        if(decimal2 == null ){
            decimal2= new BigDecimal(0);
        }
        return decimal1.compareTo(decimal2);
    }

    public static  BigDecimal roundTwoPre(BigDecimal src){
        return src == null ? src : src.setScale(2, BigDecimal.ROUND_HALF_EVEN) ;
    }

}
