package com.ejianc.business.steelstructure.income.utils;

import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Component
public class UpSumUtil<T> {

    /**
     * 树转list
     *
     * @param list
     * @return
     */
    public List<T> treeToList(List<T> list) {
        List<T> result = new ArrayList<>();
        for (T t : list) {
            result.add(t);
            List<T> children = getChilerenValue(t, "children");
            if (children != null && children.size() > 0) {
                List<T> tes = treeToList(children);
                result.addAll(tes);
            }
        }
        if (result.size() > 0) {
            for (T t : result) {
                setChilerenValue(t, "children", null);
            }
        }
        return result;
    }

    /**
     * 向上汇总金额
     *
     * @param list    树形结构，必须有children字段
     * @param columns 需要汇总的字段
     * @return
     */
    public List<T> upSum(List<T> list, String... columns) {
        for (T t : list) {
            List<T> children = getChilerenValue(t, "children");
            if (children != null && children.size() > 0) {
                List<T> c = upSum(children, columns);
                sumColumns(t, c, columns);
            }
        }
        return list;
    }

    private void sumColumns(T t, List<T> children, String... columns) {
        for (String column : columns) {
            BigDecimal sum = BigDecimal.ZERO;
            for (T c : children) {
                BigDecimal bigDecimalValue = getBigDecimalValue(c, column);
                sum = MathUtil.safeAdd(sum, bigDecimalValue);
            }
            setValue(t, column, sum);
        }
        setChilerenValue(t, "children", children);
    }

    private List<T> getChilerenValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                return (List<T>) m.invoke(t, (Object[]) null);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }

    private BigDecimal getBigDecimalValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                return (BigDecimal) m.invoke(t, (Object[]) null);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }

    private void setValue(T t, String code, BigDecimal value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), BigDecimal.class);
            try {
                subPid.invoke(t, value);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置set方法！");
        }
    }

    private void setChilerenValue(T t, String code, List<T> value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), List.class);
            try {
                subPid.invoke(t, value);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的set方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置set方法！");
        }
    }

}
