package com.ejianc.business.steelstructure.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 其他收入合同结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_other_settle")
public class OtherSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="settle_date")
    private Date settleDate; // 报量时间
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="settle_tax_mny")
    private BigDecimal settleTaxMny; // 本期结算金额（含税）
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="tax")
    private BigDecimal tax; // 税金
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 本期结算金额（不含税）
    @TableField(value="sum_settle_mny")
    private BigDecimal sumSettleMny; // 截至上期累计结算金额（不含税）
    @TableField(value="sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny; // 截至上期累计结算金额（含税）
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="sum_settle_rate")
    private BigDecimal sumSettleRate; // 截至上期累计结算比例
    @TableField(value="total_settle_mny")
    private BigDecimal totalSettleMny; // 累计结算金额（不含税）
    @TableField(value="total_settle_tax_mny")
    private BigDecimal totalSettleTaxMny; // 累计结算金额（含税）
    @TableField(value="total_settle_rate")
    private BigDecimal totalSettleRate; // 累计结算比例
    @TableField(value="source_id")
    private String sourceId; // 来源主键
    @TableField(value="dept_id")
    private Long deptId; // 部门id
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="settle_type")
    private String settleType;
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方
    @TableField(value="customer_name")
    private String customerName; // 合同甲方名称

    @TableField(exist=false)
    @SubEntity(serviceName="otherSettleDetailService",pidName = "settleId")
    private List<OtherSettleDetailEntity> otherSettleDetailList = new ArrayList<>(); // 其他收入合同结算明细


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getSumSettleRate() {
        return sumSettleRate;
    }

    public void setSumSettleRate(BigDecimal sumSettleRate) {
        this.sumSettleRate = sumSettleRate;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleRate() {
        return totalSettleRate;
    }

    public void setTotalSettleRate(BigDecimal totalSettleRate) {
        this.totalSettleRate = totalSettleRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<OtherSettleDetailEntity> getOtherSettleDetailList() {
        return otherSettleDetailList;
    }

    public void setOtherSettleDetailList(List<OtherSettleDetailEntity> otherSettleDetailList) {
        this.otherSettleDetailList = otherSettleDetailList;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
