package com.ejianc.business.steelstructure.other.controller;

import com.ejianc.business.steelstructure.other.service.IOtherHistoryService;
import com.ejianc.business.steelstructure.other.vo.OtherHistoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 其他收入合同记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherHistory")
public class OtherHistoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOtherHistoryService historyService;
    /**
     * 根据变更主键ID查询历史详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailByChangeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherHistoryVO> queryDetailByChangeId(@RequestParam Long id) {
        OtherHistoryVO OtherHistoryVO = historyService.queryDetailByChangeId(id);
        return CommonResponse.success(OtherHistoryVO);
    }
}
