package com.ejianc.business.steelstructure.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.steelstructure.income.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.other.bean.*;
import com.ejianc.business.steelstructure.other.service.*;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("otherChange") 
public class OtherChangeBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IOtherChangeService changeService;
	@Autowired
	private IOtherChangeDetailService changeDetailService;
	@Autowired
	private IOtherChangeClauseService changeClauseService;
	@Autowired
	private IOtherContractService contractService;
	@Autowired
	private IOtherDetailService contractDetailService;
	@Autowired
	private IOtherClauseService contractClauseService;
	@Autowired
	private IOtherHistoryService historyService;
	@Autowired
	private IOtherHistoryDetailService historyDetailService;
	@Autowired
	private IOtherHistoryClauseService historyClauseService;
	@Autowired
	private IAttachmentApi attachmentApi;

	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
		//变更表
		OtherChangeEntity entity = changeService.selectById(billId);
		//合同主表
		OtherContractEntity otherContractEntity = contractService.selectById(entity.getContractId());

		//同步原合同到记录表
		OtherHistoryEntity otherHistoryEntity = BeanMapper.map(otherContractEntity, OtherHistoryEntity.class);
		otherHistoryEntity.setContractId(entity.getContractId());//原合同主键
		otherHistoryEntity.setId(null);
		historyService.saveOrUpdate(otherHistoryEntity,false);

		//同步原清单到记录表
		QueryParam deparm = new QueryParam();
		deparm.getParams().put("contractId", new Parameter(QueryParam.EQ, otherContractEntity.getId()));
		List<OtherDetailEntity> checkList = contractDetailService.queryList(deparm,false);
		if(null!=checkList&&checkList.size()>0){
			List<OtherHistoryDetailEntity> historyDetails = BeanMapper.mapList(checkList, OtherHistoryDetailEntity.class);
			for(OtherHistoryDetailEntity hde:historyDetails){
				hde.setHistoryId(otherHistoryEntity.getId());//记录表主键
				hde.setContractId(entity.getContractId());//原合同主键
				hde.setContractBid(hde.getId());//原合同子表主键
				hde.setId(null);
			}
			historyDetailService.saveOrUpdateBatch(historyDetails,historyDetails.size(),false);
		}

		//同步原条款到记录表
		List<OtherClauseEntity> clauseList = contractClauseService.queryList(deparm,false);
		if(null!=clauseList&&clauseList.size()>0){
			List<OtherHistoryClauseEntity> historyClauses = BeanMapper.mapList(clauseList, OtherHistoryClauseEntity.class);
			for(OtherHistoryClauseEntity hce:historyClauses){
				hce.setHistoryId(otherHistoryEntity.getId());//记录表主键
				hce.setContractId(entity.getContractId());//原合同主键
				hce.setContractBid(hce.getId());//原合同子表主键
				hce.setId(null);
			}
			historyClauseService.saveOrUpdateBatch(historyClauses,historyClauses.size(),false);
		}

		//回写合同主表

		otherContractEntity.setBeforeChangeTaxMny(otherContractEntity.getContractTaxMny());//变更后金额变为变更前金额
		otherContractEntity.setBeforeChangeMny(otherContractEntity.getContractMny());//变更后金额变为变更前金额
		otherContractEntity.setContractTaxMny(otherContractEntity.getChangingTaxMny());//变更中金额变为变更后金额
		otherContractEntity.setContractMny(otherContractEntity.getChangingMny());//变更中金额变为变更后金额
		otherContractEntity.setChangingTaxMny(null);//变更中金额清空
		otherContractEntity.setChangingMny(null);//变更中金额清空
		otherContractEntity.setChangeStatus("3");//状态改为已变更
		otherContractEntity.setChangeCode(otherContractEntity.getChangeCode());
		otherContractEntity.setChangeId(otherContractEntity.getChangeId());
		otherContractEntity.setBillState(otherContractEntity.getBillState());
		otherContractEntity.setSumSettleTaxMny(otherContractEntity.getSumSettleTaxMny());
		otherContractEntity.setSumSettleMny(otherContractEntity.getSumSettleMny());
//		otherContractEntity.setSumCollectMny(otherContractEntity.getSumCollectMny());
//		otherContractEntity.setSumInvoicingTaxMny(otherContractEntity.getSumInvoicingTaxMny());
//		otherContractEntity.setSumInvoicingMny(otherContractEntity.getSumInvoicingMny());

		otherContractEntity.setProjectId(entity.getProjectId());
		otherContractEntity.setProjectCode(entity.getProjectCode());
		otherContractEntity.setProjectName(entity.getProjectName());
		otherContractEntity.setContractName(entity.getContractName());
		otherContractEntity.setBillCode(entity.getBillCode());
		otherContractEntity.setOrgId(entity.getOrgId());
		otherContractEntity.setOrgCode(entity.getOrgCode());
		otherContractEntity.setOrgName(entity.getOrgName());
		otherContractEntity.setParentOrgId(entity.getParentOrgId());
		otherContractEntity.setParentOrgCode(entity.getParentOrgCode());
		otherContractEntity.setParentOrgName(entity.getParentOrgName());
		otherContractEntity.setContractStatus(entity.getContractStatus());
		otherContractEntity.setCustomerId(entity.getCustomerId());
		otherContractEntity.setCustomerName(entity.getCustomerName());
		otherContractEntity.setSupplierId(entity.getSupplierId());
		otherContractEntity.setSupplierName(entity.getSupplierName());
		otherContractEntity.setTaxRate(entity.getTaxRate());
		otherContractEntity.setSignDate(entity.getSignDate());
		otherContractEntity.setEmployeeId(entity.getEmployeeId());
		otherContractEntity.setEmployeeName(entity.getEmployeeName());
		otherContractEntity.setDeptId(entity.getDeptId());
		otherContractEntity.setDeptName(entity.getDeptName());
		otherContractEntity.setMemo(entity.getMemo());
		otherContractEntity.setTaxMny(entity.getTaxMny());
		otherContractEntity.setChangeReason(entity.getChangeReason());
		otherContractEntity.setChangeVersion(entity.getChangeVersion());
		//回写原合同清单表
		contractDetailService.deleteByContractId(entity.getContractId());
		QueryParam parm = new QueryParam();
		parm.getParams().put("changeId", new Parameter(QueryParam.EQ, entity.getId()));
		List<OtherChangeDetailEntity> changeDetailList = changeDetailService.queryList(parm, false);
		if(null!=changeDetailList&&changeDetailList.size()>0){
			List<OtherDetailEntity> detailList=new ArrayList<>();
			for(OtherChangeDetailEntity cde:changeDetailList){
				OtherDetailEntity cdetail = BeanMapper.map(cde, OtherDetailEntity.class);
				cdetail.setId(null);
				cdetail.setChangeBid(cde.getId());
				//变更类型如果是中止，不能改类型
				if(null==cdetail.getChangeType()||cdetail.getChangeType()!=5){
					cdetail.setChangeType(6);
				}

				detailList.add(cdetail);
			}
			contractDetailService.saveOrUpdateBatch(detailList,detailList.size(),false);
		}

		//回写原合同条款表
		List<OtherChangeClauseEntity> changeClauseList = changeClauseService.queryList(parm, false);
		contractClauseService.remove(new QueryWrapper<OtherClauseEntity>().eq("contract_id",entity.getContractId()),false);
		if(null!=changeClauseList&&changeClauseList.size()>0){
			List<OtherClauseEntity> contractClauses = BeanMapper.mapList(changeClauseList, OtherClauseEntity.class);
			for(OtherClauseEntity cce:contractClauses){
				cce.setChangeId(cce.getChangeId());
				cce.setChangeBid(cce.getId());
				cce.setId(null);
			}
			contractClauseService.saveOrUpdateBatch(contractClauses,contractClauses.size(),false);
		}
		entity.setUsedTime(new Date());
		entity.setBeforeContractName(otherContractEntity.getContractName());
		changeService.saveOrUpdate(entity,false);

		// 同步附件
		logger.info("同步附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), "EJCBT202205000018", null,
				String.valueOf(otherContractEntity.getId()), "EJCBT202205000014", null);
		logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

		//合同推送合同池
		boolean pushResult = contractService.pushContract(BeanMapper.map(otherContractEntity, OtherContractVO.class),true);
		if(pushResult) {
			otherContractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			otherContractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		contractService.saveOrUpdate(otherContractEntity);
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
		return CommonResponse.error("合同变更单暂不支持回退功能!");
	}
}
