package com.ejianc.business.steelstructure.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.income.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherContractRelieveEntity;
import com.ejianc.business.steelstructure.other.service.IOtherContractRelieveService;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("otherContractRelieve") 
public class OtherContractRelieveBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOtherContractRelieveService relieveService;

	@Autowired
	private IOtherContractService contractService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		OtherContractRelieveEntity entity = relieveService.selectById(billId);

		// 回写合同解除状态
		LambdaUpdateWrapper<OtherContractEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(OtherContractEntity::getIsRelieve, 1);
		wrapper.set(OtherContractEntity::getContractStatus, "5");
		wrapper.eq(BaseEntity::getId, entity.getContractId());
		contractService.update(wrapper);


		OtherContractEntity contractRegisterEntity = contractService.selectById(entity.getContractId());
		//合同推送合同池，更新解除状态
		boolean pushResult = contractService.pushContract(BeanMapper.map(contractRegisterEntity, OtherContractVO.class),true);
		if(pushResult) {
			contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		contractService.saveOrUpdate(contractRegisterEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		OtherContractRelieveEntity entity = relieveService.selectById(billId);

		// 回写合同解除状态
		LambdaUpdateWrapper<OtherContractEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(OtherContractEntity::getIsRelieve, 0);
		wrapper.set(OtherContractEntity::getContractStatus, "2");
		wrapper.eq(BaseEntity::getId, entity.getContractId());
		contractService.update(wrapper);


		OtherContractEntity contractRegisterEntity = contractService.selectById(entity.getContractId());
		//合同推送合同池，更新解除状态
		boolean pushResult = contractService.pushContract(BeanMapper.map(contractRegisterEntity, OtherContractVO.class),true);
		if(pushResult) {
			contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			contractRegisterEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		contractService.saveOrUpdate(contractRegisterEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
