package com.ejianc.business.steelstructure.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.income.utils.ValidateUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherContractSuspendEntity;
import com.ejianc.business.steelstructure.other.history.OtherContractSuspendHistoryVO;
import com.ejianc.business.steelstructure.other.mapper.OtherContractSuspendMapper;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherContractSuspendService;
import com.ejianc.business.steelstructure.other.vo.OtherContractSuspendVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 其他收入合同冻结
 * 
 * @author generator
 * 
 */
@Service("otherContractSuspendService")
public class OtherContractSuspendServiceImpl extends BaseServiceImpl<OtherContractSuspendMapper, OtherContractSuspendEntity> implements IOtherContractSuspendService{
    private static final String OTHER_SUSPEND_RELIEVE = "OTHER_SUSPEND_RELIEVE";//此处需要根据实际修改
    private static final String OTHER_CODE = "EJCBT202205000014";//此处需要根据实际修改

    @Autowired
    private IOtherContractService service;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ValidateUtil validateUtil;

    @Override
    public OtherContractSuspendVO saveOrUpdate(OtherContractSuspendVO saveOrUpdateVO) {
         //保存时校验合同version是否一致
        if (!Objects.equals(null, saveOrUpdateVO.getContractId())) {
            if(!validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()),
                    OTHER_CODE, saveOrUpdateVO.getContractVersion())){
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }

        OtherContractSuspendEntity entity = BeanMapper.map(saveOrUpdateVO, OtherContractSuspendEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            validateContract(entity.getContractId(), entity.getId());

            BillCodeParam billCodeParam = BillCodeParam.build(OTHER_SUSPEND_RELIEVE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            // 修改
            validateContract(entity.getContractId(), entity.getId());

        }
        this.saveOrUpdate(entity, false);
        OtherContractSuspendVO vo = BeanMapper.map(entity, OtherContractSuspendVO.class);
        return vo;
    }

    @Override
    public OtherContractSuspendVO queryLastSuspend(Long contractId) {
        List<OtherContractSuspendEntity> list = querySuspendByContractId(contractId);
        if (ListUtil.isEmpty(list)) {
            return new OtherContractSuspendVO();
        }
        return BeanMapper.map(list.get(0), OtherContractSuspendVO.class);
    }

    @Override
    public OtherContractSuspendHistoryVO querySuspendRecord(Long id) {
        OtherContractEntity entity = service.selectById(id);
        OtherContractSuspendHistoryVO vo = new OtherContractSuspendHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        LambdaQueryWrapper<OtherContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractSuspendEntity::getContractId, id);
        //wrapper.orderByDesc(OtherContractSuspendEntity::getSuspendRelieveDate);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List<OtherContractSuspendEntity> list = super.list(wrapper);
        vo.setDetailList(BeanMapper.mapList(list, OtherContractSuspendVO.class));
        return vo;
    }

    @Override
    public List<OtherContractSuspendEntity> querySuspendByContractId(Long contractId) {
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper<OtherContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractSuspendEntity::getContractId, contractId);
        wrapper.in(OtherContractSuspendEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List<OtherContractSuspendEntity> list = this.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    @Override
    public Boolean validateContract(Long contractId, Long id) {
        //同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<OtherContractSuspendEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过的合同冻结，不允许新增!");
        }
        return true;
    }

}
