package com.ejianc.business.steelstructure.other.service.impl;

import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSettleEntity;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherSettleService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.business.steelstructure.other.vo.OtherSettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service("otherSettle") 
public class OtherSettleBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IOtherContractService contractService;
	@Autowired
	private IOtherSettleService service;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//结算单
		OtherSettleEntity entity = service.selectById(billId);
		//推送结算池所用vo
		OtherContractEntity contractEntity = contractService.selectById(entity.getContractId());
		if ("1".equals(entity.getSettleType())){
			if ("sucPushed".equals(contractEntity.getBillPushFlag())){
				boolean pushResult = service.pushContract(BeanMapper.map(contractEntity, OtherContractVO.class),"3");
				if(!pushResult){
					return CommonResponse.error("推送合同池失败");
				}
			}
		}else {
			//推送结算池所用vo
			OtherSettleVO settlementVO = BeanMapper.map(entity, OtherSettleVO.class);
			//推送结算池
			boolean pool = service.pushSettleToPool(settlementVO);
			if(!pool){
				return CommonResponse.error("推送结算池失败");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写主表
		OtherSettleEntity otherSettleEntity = service.selectById(billId);
		OtherContractEntity contractEntity = contractService.selectById(otherSettleEntity.getContractId());
		//本期报结算金额（含税）
		BigDecimal quoteTaxMny = otherSettleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : otherSettleEntity.getSettleTaxMny();
		//累计结算含税）
		BigDecimal sumQuoteTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
		//累加
		contractEntity.setSumSettleTaxMny(quoteTaxMny.add(sumQuoteTaxMny));
		//本期结算金额（不含税）
		BigDecimal quoteMny = otherSettleEntity.getSettleMny() == null ? BigDecimal.ZERO : otherSettleEntity.getSettleMny();
		//累计结算（不含税）
		BigDecimal sumQuoteMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
		//累计结算（不含税）
		contractEntity.setSumSettleMny(quoteMny.add(sumQuoteMny));
		if ("1".equals(otherSettleEntity.getSettleType())){
			contractEntity.setContractStatus("3");
		}
		//contractEntity.setIsFinish(1);
		contractService.updateById(contractEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OtherSettleEntity quoteEntity = service.selectById(billId);
		OtherContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
		if ("1".equals(quoteEntity.getSettleType())) {
			if ("sucPushed".equals(contractEntity.getBillPushFlag())){
				boolean pushResult = service.pushContract(BeanMapper.map(contractEntity, OtherContractVO.class),"2");
				if(!pushResult){
					return CommonResponse.error("弃审推送合同池失败");
				}
			}
			boolean pool = service.delSettleFromPool(billId);
			if(!pool){
				return CommonResponse.error("弃审推送结算池失败");
			}
		}
		//本期结算金额（含税）
		BigDecimal quoteTaxMny = quoteEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getSettleTaxMny();
		//累计结算（含税）
		BigDecimal sumQuoteTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
		//累减
		contractEntity.setSumSettleTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));
		//本期结算金额（不含税）
		BigDecimal quoteMny = quoteEntity.getSettleMny() == null ? BigDecimal.ZERO : quoteEntity.getSettleMny();
		//累计结算（不含税）
		BigDecimal sumQuoteMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
		//累计结算（不含税）
		contractEntity.setSumSettleMny(sumQuoteMny.subtract(quoteMny));
		if ("1".equals(quoteEntity.getSettleType())){
			contractEntity.setContractStatus("2");
		}
		//contractEntity.setIsFinish(0);
		contractService.updateById(contractEntity);

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
