package com.ejianc.business.steelstructure.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSettleEntity;
import com.ejianc.business.steelstructure.other.history.OtherSettleHistoryVO;
import com.ejianc.business.steelstructure.other.mapper.OtherSettleMapper;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherSettleService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.business.steelstructure.other.vo.OtherSettleVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 其他收入合同结算
 * 
 * @author generator
 * 
 */
@Service("otherSettleService")
public class OtherSettleServiceImpl extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity> implements IOtherSettleService{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String OTHER_SETTLE_CODE = "OTHER_SETTLE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private OtherSettleMapper otherSettleMapper;

    @Autowired
    private IOtherContractService contractService;

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public OtherSettleVO saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            BillCodeParam billCodeParam = BillCodeParam.build(OTHER_SETTLE_CODE,tenantId,saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OtherContractEntity contractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if(contractEntity != null && "2".equals(contractEntity.getChangeStatus())){
            throw new BusinessException("该合同处于变更中状态，不能做合同结算!");
        }

        LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherContractEntity::getMainContractId,saveorUpdateVO.getContractId());
        lambda.eq(OtherContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getSupplementFlag, 1);
        int conNum = contractService.count(lambda);
        if (conNum > 0) {
            throw new BusinessException("该合同存在未生效的补充协议，不能做合同结算!");
        }
        if ("3".equals(contractEntity.getContractStatus()) && "0".equals(saveorUpdateVO.getSettleType())){
            throw new BusinessException("该合同已封账，不能做过程结算!");
        }
        //合同结算只能存在一条未生效的
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
        lambdaQuery.notIn(OtherSettleEntity::getBillState,1,3);
        //lambdaQuery.eq(OtherSettleEntity::getSettleType, "1");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            lambdaQuery.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
        }
        int num = this.count(lambdaQuery);
        if (num > 0) {
            throw new BusinessException("该合同存在未生效的合同结算!");
        }

        Date signDate = contractEntity.getSignDate();
        if (null != signDate && saveorUpdateVO.getSettleDate().getTime() < signDate.getTime()) {
            throw new BusinessException("结算日期只能是大于等于其他收入合同的签约日期");
        }
        OtherSettleEntity entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
        super.saveOrUpdate(entity, false);
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OtherContractEntity::getIsFinish, 1);
        updateWrapper.eq(OtherContractEntity::getId, saveorUpdateVO.getContractId());
        contractService.update(updateWrapper);
        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return vo;
    }


    @Override
    public OtherSettleHistoryVO querySettleHistory(Long id) {
//        List<Integer> billStatus = new ArrayList<>();
//        billStatus.add(1);
//        billStatus.add(3);  .in("bill_state", billStatus)
        List<OtherSettleEntity> quoteEntities = otherSettleMapper.selectList(new QueryWrapper<OtherSettleEntity>()
                .eq("contract_id", id)
                .orderByDesc("settle_date", "create_time"));
        OtherContractEntity contractEntity = contractService.selectById(id);
        OtherSettleHistoryVO vo = new OtherSettleHistoryVO();
        vo.setContractId(id);
        vo.setSettleFlag("2".equals(contractEntity.getContractStatus())?0:1);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setIsSuspend(contractEntity.getIsSuspend());
        vo.setIsRelieve(contractEntity.getIsRelieve());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setTotalSettleTaxMny(contractEntity.getSumSettleTaxMny());
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setTotalSettleRate(BigDecimal.ZERO);//累计形象进度
        } else {
            vo.setTotalSettleRate(sumSettleTaxMny.divide(contractEntity.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
        }
        vo.setSettleRecord(BeanMapper.mapList(quoteEntities, OtherSettleVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(OtherSettleVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送合同池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送合同池异常!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",id, res.getMsg());
            }
        }catch (Exception e){
            logger.error("结算单弃审推送合同池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送合同池异常!");
        }
        return flag;
    }

    @Override
    public boolean pushContract(OtherContractVO vo, String performanceStatus) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            contractService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert(vo, data);
            data.setPerformanceStatus(performanceStatus);
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.其他收入合同.getTypeCode());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-steelstructure-frontend/#/otherContract/otherContractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-steelstructure-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            }
            data.setPcCardUrl(url);


            //从项目池中获取数据获取
            CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null){
                ProjectPoolSetVO data1 = projectPoolSetVO.getData();
                if (data1.getAreaName() != null){
                    data.setAreaName(data1.getAreaName());//所在地区
                }
                if (data1.getAddress() != null){
                    data.setAddress(data1.getAddress());//详细地址
                }
                if (data1.getEngineeringType() != null){
                    CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data1.getEngineeringTypeId());
                    if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                        data.setEngineeringType(defDocById.getData().getName());//工程类别
                    }
                }
//                if (data1.getMeasureType() != null  && data1.getMeasureType().equals(1506803511994617857L) && data1.getMeasureValue() != null){
//                    pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
//                }
//                if (data1.getPlanStartDate() != null){
//                    pmContractVO.setKgrq(sdf.format(data1.getPlanStartDate()));//开工日期
//                }
//                if (data1.getPlanEndDate() != null){
//                    pmContractVO.setJgrq(sdf.format(data1.getPlanEndDate()));//竣工日期
//                }
//                if (data1.getProjectManagementName() != null){
//                    pmContractVO.setXmfzr(data1.getProjectManagementName());//项目负责人
//                }
//                if (data1.getProjectManagementPhone() != null){
//                    pmContractVO.setXmfzedh(data1.getProjectManagementPhone());//项目负责人电话
//                }
            }



            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}", vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    // 将SettleReportVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(OtherSettleVO vo, SettlePoolVO spv) {
        spv.setSourceType("other_in");//结算类型
        spv.setSourceId(vo.getId());//结算单id
        spv.setId(vo.getId());
        spv.setSettleProperty(1);//属性类别=收入
        spv.setUltimateFlag("1".equals(vo.getSettleType())?1:0);//是否最终结算=否
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/otherSettle/card?id=" + vo.getId());// 穿透地址
        if(vo.getContractId()!=null){//有合同需要推送的字段
            //查询合同
            OtherContractEntity contractEntity = contractService.selectById(vo.getContractId());
            spv.setContractType("otherIn");
            spv.setContractFlag(1);//合同标识
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setPartybId(contractEntity.getSupplierId());//乙方id
            spv.setPartybName(contractEntity.getSupplierName());//乙方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            BigDecimal lastTaxMny = BigDecimal.ZERO; // 截止本期累计结算金额
            BigDecimal lastMny = BigDecimal.ZERO; // 截止本期累计结算金额（无税）
            BigDecimal lastTax = BigDecimal.ZERO; // 截止本期累计结算税额
            /*获取除本次累计结算金额*/
            LambdaQueryWrapper<OtherSettleEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.orderByDesc(OtherSettleEntity::getCreateTime);
            wrapper.in(OtherSettleEntity::getBillState, 1,3);
            wrapper.eq(OtherSettleEntity::getDr, 0);
            wrapper.eq(OtherSettleEntity::getContractId, vo.getContractId());
            wrapper.ne(OtherSettleEntity::getId,vo.getId());
            List<OtherSettleEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (OtherSettleEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getSettleTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettleTaxMny();
                    BigDecimal settMny = settlementEntity.getSettleMny()==null?BigDecimal.ZERO:settlementEntity.getSettleMny();
                    BigDecimal settTax = settlementEntity.getTax()==null?BigDecimal.ZERO:settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(lastMny);//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(lastTax);//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成");
    }
}
