package com.ejianc.business.steelstructure.other.service.impl;

import com.ejianc.business.steelstructure.income.utils.MathUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherDetailEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSupplementDetailEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSupplementEntity;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherDetailService;
import com.ejianc.business.steelstructure.other.service.IOtherSupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("otherSupplement") 
public class OtherSupplementBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IOtherSupplementService supplementService;

	@Autowired
	private IOtherContractService contractService;

	@Autowired
	private IOtherDetailService contractDetailService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OtherSupplementEntity otherSupplementEntity = supplementService.selectById(billId);
		OtherContractEntity otherContractEntity  = contractService.selectById(otherSupplementEntity.getMainContractId());
		otherContractEntity.setContractMny(MathUtil.safeAdd(otherContractEntity.getContractMny(), otherSupplementEntity.getContractMny()));
		otherContractEntity.setContractTaxMny(MathUtil.safeAdd(otherContractEntity.getContractTaxMny(), otherSupplementEntity.getContractTaxMny()));
		otherContractEntity.setTaxMny(MathUtil.safeSub(otherContractEntity.getContractTaxMny(), otherContractEntity.getContractMny()));
		otherSupplementEntity.setChangeStatus("2");
		supplementService.updateById(otherSupplementEntity);
		contractService.updateById(otherContractEntity);

		dealDetailData(otherSupplementEntity, otherContractEntity);

		return CommonResponse.success();
	}

	private void dealDetailData(OtherSupplementEntity otherSupplementEntity, OtherContractEntity otherContractEntity){
		List<OtherDetailEntity> detailList = otherContractEntity.getCheckList();
		if(CollectionUtils.isNotEmpty(otherSupplementEntity.getCheckList())){
			for(OtherSupplementDetailEntity detailEntity : otherSupplementEntity.getCheckList()){
				OtherDetailEntity OtherDetailEntity = BeanMapper.map(detailEntity, OtherDetailEntity.class);
				OtherDetailEntity.setId(null);
				OtherDetailEntity.setContractId(otherContractEntity.getId());
				OtherDetailEntity.setSrcSupplementDetailId(detailEntity.getId());
				OtherDetailEntity.setSrcSupplementFlag(1);
				OtherDetailEntity.setSrcSupplementId(otherSupplementEntity.getId());
				detailList.add(OtherDetailEntity);
			}
			contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("补充协议暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
