package com.ejianc.business.steelstructure.prosub.prosub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 分包合同明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_contract_detail")
public class ContractDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 清单编号
     */
    @TableField("detail_code")
    private String detailCode;

    /**
     * 清单名称
     */
    @TableField("detail_name")
    private String detailName;

    /**
     * 清单价格类型
     */
    @TableField(value = "doc_price_type_name")
    private String docPriceTypeName;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    /**
     * 工作内容
     */
    @TableField("detail_work_content")
    private String detailWorkContent;

    /**
     * 计量规则
     */
    @TableField("detail_measurement_rules")
    private String detailMeasurementRules;

    /**
     * 单位
     */
    @TableField("detail_unit")
    private String detailUnit;

    /**
     * 工程量
     */
    @TableField("detail_num")
    private BigDecimal detailNum;

    /**
     * 定标来源的工程量
     */
    @TableField("detail_target_result_num")
    private BigDecimal detailTargetResultNum;


    /**
     * 单价（无税）
     */
    @TableField("detail_price")
    private BigDecimal detailPrice;

    /**
     * 定标来源的单价（无税）
     */
    @TableField("detail_target_result_price")
    private BigDecimal detailTargetResultPrice;
    /**
     * 定标来源的单价
     */
    @TableField("detail_target_result_tax_price")
    private BigDecimal detailTargetResultTaxPrice;
    /**
     * 初始版本占用定标工程量
     */
    @TableField("detail_base_target_result_num")
    private BigDecimal detailBaseTargetResultNum;

    /**
     * 定标来源的sellId（用于定标回写）
     */
    @TableField("detail_target_result_sell_id")
    private Long detailTargetResultSellId;


    /**
     * 税率
     */
    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;

    /**
     * 金额（无税）
     */
    @TableField("detail_mny")
    private BigDecimal detailMny;

    /**
     * 单价(含税）
     */
    @TableField("detail_tax_price")
    private BigDecimal detailTaxPrice;

    /**
     * 金额（含税）
     */
    @TableField("detail_tax_mny")
    private BigDecimal detailTaxMny;

    /**
     * 税额
     */
    @TableField("detail_tax")
    private BigDecimal detailTax;

    /**
     * 备注
     */
    @TableField("detail_memo")
    private String detailMemo;

    /**
     * 来源数据Id
     */
    @TableField("source_id")
    private Long sourceId;

    /**
     * 来源类型：1-定标结果带入
     */
    @TableField("source_type")
    private String sourceType;

    /**
     * 所属合同Id
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    /**
     * 变更类型
     */
    @TableField("change_type")
    private String changeType;

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 档案分类Id
     */
    @TableField("doc_category_id")
    private Long docCategoryId;

    /**
     * 档案Id
     */
    @TableField("doc_id")
    private Long docId;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;


    /**
     * 总计划id（总计划来源的数据的总计划id）
     */
    @TableField("plan_id")
    private Long planId;


    /**
     * 人工费金额（含税）
     */
    @TableField("detail_artificial_tax_mny")
    private BigDecimal detailArtificialTaxMny;

    /**
     * 人工费金额（无税）
     */
    @TableField("detail_artificial_mny")
    private BigDecimal detailArtificialMny;

    /**
     * 人工费税额
     */
    @TableField("detail_artificial_tax")
    private BigDecimal detailArtificialTax;

    /**
     * 人工费单价（含税）
     */
    @TableField("detail_artificial_tax_price")
    private BigDecimal detailArtificialTaxPrice;

    /**
     * 人工费单价（无税）
     */
    @TableField("detail_artificial_price")
    private BigDecimal detailArtificialPrice;

    /**
     * 是否末级
     */
    @TableField(value="leaf_flag")
    private Boolean leafFlag;

    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    @TableField(value="fall_rate")
    private BigDecimal fallRate; // 下浮率


    public BigDecimal getFallRate() {
        return fallRate;
    }

    public void setFallRate(BigDecimal fallRate) {
        this.fallRate = fallRate;
    }

    public String getDocPriceTypeName() {
        return docPriceTypeName;
    }

    public void setDocPriceTypeName(String docPriceTypeName) {
        this.docPriceTypeName = docPriceTypeName;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public BigDecimal getDetailArtificialTaxMny() {
        return detailArtificialTaxMny;
    }

    public void setDetailArtificialTaxMny(BigDecimal detailArtificialTaxMny) {
        this.detailArtificialTaxMny = detailArtificialTaxMny;
    }

    public BigDecimal getDetailArtificialMny() {
        return detailArtificialMny;
    }

    public void setDetailArtificialMny(BigDecimal detailArtificialMny) {
        this.detailArtificialMny = detailArtificialMny;
    }

    public BigDecimal getDetailArtificialTax() {
        return detailArtificialTax;
    }

    public void setDetailArtificialTax(BigDecimal detailArtificialTax) {
        this.detailArtificialTax = detailArtificialTax;
    }

    public BigDecimal getDetailArtificialTaxPrice() {
        return detailArtificialTaxPrice;
    }

    public void setDetailArtificialTaxPrice(BigDecimal detailArtificialTaxPrice) {
        this.detailArtificialTaxPrice = detailArtificialTaxPrice;
    }

    public BigDecimal getDetailArtificialPrice() {
        return detailArtificialPrice;
    }

    public void setDetailArtificialPrice(BigDecimal detailArtificialPrice) {
        this.detailArtificialPrice = detailArtificialPrice;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getDetailTargetResultNum() {
        return detailTargetResultNum;
    }

    public void setDetailTargetResultNum(BigDecimal detailTargetResultNum) {
        this.detailTargetResultNum = detailTargetResultNum;
    }

    public BigDecimal getDetailTargetResultPrice() {
        return detailTargetResultPrice;
    }

    public void setDetailTargetResultPrice(BigDecimal detailTargetResultPrice) {
        this.detailTargetResultPrice = detailTargetResultPrice;
    }

    public BigDecimal getDetailBaseTargetResultNum() {
        return detailBaseTargetResultNum;
    }

    public void setDetailBaseTargetResultNum(BigDecimal detailBaseTargetResultNum) {
        this.detailBaseTargetResultNum = detailBaseTargetResultNum;
    }

    public Long getDetailTargetResultSellId() {
        return detailTargetResultSellId;
    }

    public void setDetailTargetResultSellId(Long detailTargetResultSellId) {
        this.detailTargetResultSellId = detailTargetResultSellId;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public BigDecimal getDetailTargetResultTaxPrice() {
        return detailTargetResultTaxPrice;
    }

    public void setDetailTargetResultTaxPrice(BigDecimal detailTargetResultTaxPrice) {
        this.detailTargetResultTaxPrice = detailTargetResultTaxPrice;
    }
}
