package com.ejianc.business.steelstructure.prosub.prosub.dataModel.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型和单据子表的枚举
 */
public enum DetailSourceTypeEnum {

    档案("doc", "档案"),
    总计划("plan", "总计划"),
    目标成本("target", "目标成本"),
    定标结果("targetResult", "定标结果");


    private String code;

    private String name;
    private String className;

    private static Map<String, DetailSourceTypeEnum> enumMap = new HashMap();

    private DetailSourceTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, DetailSourceTypeEnum> enumMap) {
        DetailSourceTypeEnum.enumMap = enumMap;
    }

    public static DetailSourceTypeEnum getByCode(String code) {
        return (DetailSourceTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(DetailSourceTypeEnum.class).stream().collect(Collectors.toMap(DetailSourceTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
