package com.ejianc.business.steelstructure.prosub.prosub.mapper;


import com.ejianc.business.prosub.dataModel.vo.ContractDataModelVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractDetailEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 分包合同明细实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractDetailMapper extends BaseCrudMapper<ContractDetailEntity> {

    /**
     * 根据Id物理删除数据
     *
     * @param ids
     */
    void deleteByIds(@Param("ids") List<Long> ids);

    /**
     * 根据项目维度查询合同子表数据模型信息
     * @param projectId
     * @param docIdList
     * @param contractType
     * @return
     */
    List<ContractDataModelVO> queryContractDataModel(@Param("projectId") Long projectId, @Param("docIdList") List<Long> docIdList, @Param("contractType") int contractType);

    /**
     * 项目维度查询合同明细数据模型信息-以 主合同 为主
     * @param projectId
     * @param docIdList
     * @param contractType
     * @return
     */
    List<ContractDataModelVO> queryContractDataModelByContract(@Param("projectId") Long projectId, @Param("docIdList") List<Long> docIdList, @Param("contractType") int contractType);

    /**
     * 项目维度查询合同明细数据模型信息-以 变更合同 为主
     * @param projectId
     * @param docIdList
     * @param contractType
     * @return
     */
    List<ContractDataModelVO> queryContractDataModelByChange(@Param("projectId") Long projectId, @Param("docIdList") List<Long> docIdList, @Param("contractType") int contractType);

    /**
     * 项目维度查询合同明细数据模型信息-以 总计划 为主
     * @param projectId
     * @param docIdList
     * @param contractType
     * @return
     */
    List<ContractDataModelVO> queryContractDataModelByPlan(@Param("projectId") Long projectId, @Param("docIdList") List<Long> docIdList, @Param("contractType") int contractType);

    /**
     * 项目维度查询合同明细数据模型信息-以 结算单 为主
     * @param projectId
     * @param docIdList
     * @param contractType
     * @return
     */
    List<ContractDataModelVO> queryContractDataModelBySettle(@Param("projectId") Long projectId, @Param("docIdList") List<Long> docIdList, @Param("contractType") int contractType);


}
