package com.ejianc.business.steelstructure.prosub.prosub.service;


import com.ejianc.business.prosub.vo.ChangeDetailVO;
import com.ejianc.business.prosub.vo.ChangeVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeEntity;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    // 校验  劳务/专业分包合同-变更  【合同金额】控【变更金额】  变更金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO);

    ChangeVO queryDetailRecord(Long id);

    Boolean editChangeFlag(Long id);

    ChangeVO addConvertByConId(Long contractId, Long changeId);

    ChangeVO insertOrUpdate(ChangeVO saveorUpdateVO, Boolean isControl);

    String getLinkUrl(ChangeVO cv);

    ChangeVO queryDetail(Long id);

    CommonResponse<String> deleteById(Long changeBillId);

    Map<String, Object> queryChangeCompare(Long id);

    ChangeVO queryChangeRecord(Long contractId, Long changeId);

    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, boolean filingFlag);

    void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type);

    List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList);

    List<ChangeDetailVO> selectMinDetailNumByIds(List<Long> srcTblIdList);

    /**
     * 转换目标成本推送VO
     *
     * @param ChangeVO 变更单据
     * @param linkUrl 详情页地址
     * @param subType 变更单子类型
     * @param billTypeCode 单据类型编码
     * @param lastSourceId 是否需要传递上一版本业务单据Id
     * @return
     */
    ExecutionVO targetCost(ChangeVO ChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId);

    List<ParamsCheckVO> historyPriceCtrlContractPrice(ChangeVO changeVO);


}
