package com.ejianc.business.steelstructure.prosub.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包合同明细实体
 * 
 * @author generator
 * 
 */
@Service("contractDetailService")
public class ContractDetailServiceImpl extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity> implements IContractDetailService {


    @Autowired
    private ContractDetailMapper contractDetailMapper;

    @Override
    public void deleteByIds(List<Long> ids) {
        contractDetailMapper.deleteByIds(ids);
    }

    @Override
    public List<ContractDetailVO> listByContractId(Long contractId) {
        List<ContractDetailVO> resp = new ArrayList<>();
        QueryWrapper<ContractDetailEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);

        List<ContractDetailEntity> eList = super.list(query);
        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, ContractDetailVO.class);
        }

        return resp;
    }
}
