package com.ejianc.business.steelstructure.prosub.settle.mapper;


import com.ejianc.business.steelstructure.prosub.settle.bean.SettleDeductEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-奖罚扣款单
 *
 * @author generator
 */
@Mapper
public interface SettleDeductMapper extends BaseCrudMapper<SettleDeductEntity> {

    /**
     * 查询奖罚扣款单列表数据（已生效、没有被过程结算引用、日期小于等于结算日期、日期倒序排列）
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleDeductEntity>
     */
    List<SettleDeductEntity> queryDeductList(@Param("settleType") Integer settleType,
                                             @Param("contractId") Long contractId,
                                             @Param("settleDate") Date settleDate);

}
