package com.ejianc.business.steelstructure.prosub.settle.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.steelstructure.prosub.settle.bean.SettleOddjobEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-零工登记
 *
 * @author generator
 */
@Mapper
public interface SettleOddjobMapper extends BaseCrudMapper<SettleOddjobEntity> {



    /**
     * 查询零工登记列表数据（已生效、没有被节点结算引用、日期小于等于结算日期、日期倒序排列）
     * 零工登记
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleOddjobEntity>
     */
    List<SettleOddjobEntity> queryOddjobList(@Param("settleType") Integer settleType,
                                             @Param("contractId") Long contractId,
                                             @Param("settleDate") Date settleDate);


    /**
     * 查询零工登记列表数据（已生效、没有被节点结算引用、日期小于等于结算日期、日期倒序排列）
     * 零工转扣
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleOddjobEntity>
     */
    List<SettleOddjobEntity> queryOddjobDeductList(@Param("settleType") Integer settleType,
                                                   @Param("contractId") Long contractId,
                                                   @Param("settleDate") Date settleDate);


    /**
     * 查询零工登记 列表数据（已生效、没有被节点结算引用 日期倒序排列）
     * @param page 封装的请求参数
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @return IPage<SettlePickingEntity>
     */
    IPage<SettleOddjobEntity> selectPageOddjob(Page<SettleOddjobEntity> page, @Param("settleType") Integer settleType,
                                               @Param("contractId") Long contractId);
}
