package com.ejianc.business.steelstructure.prosub.settle.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleSalaryEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-工人工资单
 *
 * @author generator
 */
@Mapper
public interface SettleSalaryMapper extends BaseCrudMapper<SettleSalaryEntity> {

    /**
     * 查询工人工资单列表数据（已生效、没有被过程结算引用、日期小于等于结算日期、日期倒序排列）
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleSalaryEntity>
     */
    List<SettleSalaryEntity> querySalaryList(@Param("settleType") Integer settleType,
                                             @Param("contractId") Long contractId,
                                             @Param("settleDate") Date settleDate);

    IPage<SettleSalaryEntity> selectPageSalary(Page<SettleSalaryEntity> page, @Param("settleType") Integer settleType,
                                               @Param("contractId") Long contractId, @Param("settleType") String settleDate);
}
